/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DurationRoutePolicy;
import org.apache.camel.spi.RoutePolicy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class DurationRoutePolicyMaxSecondsTest
extends ContextTestSupport {
    @Test
    public void testDurationRoutePolicy() {
        Assumptions.assumeTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assumptions.assumeFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped());
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
            Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped());
        });
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DurationRoutePolicy policy = new DurationRoutePolicy();
                policy.setMaxSeconds(2);
                this.from("timer:foo?delay=100&period=100").routeId("foo").routePolicy(new RoutePolicy[]{policy}).to("mock:foo");
            }
        };
    }
}

