/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DurationRoutePolicy;
import org.apache.camel.spi.RoutePolicy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationRoutePolicyMaxMessagesTest
extends ContextTestSupport {
    @Test
    public void testDurationRoutePolicy() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped());
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(5);
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
            Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped());
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DurationRoutePolicy policy = new DurationRoutePolicy();
                policy.setMaxMessages(5);
                this.from("timer:foo?period=100").routeId("foo").routePolicy(new RoutePolicy[]{policy}).to("mock:foo");
            }
        };
    }
}

