/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DurationRoutePolicyFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationRoutePolicyFactoryTest
extends ContextTestSupport {
    @Test
    public void testDurationRoutePolicyFactory() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(10);
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
            Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped());
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DurationRoutePolicyFactory factory = new DurationRoutePolicyFactory();
                factory.setMaxSeconds(2);
                factory.setMaxMessages(25);
                this.getContext().addRoutePolicyFactory((RoutePolicyFactory)factory);
                this.from("timer:foo?delay=100&period=100").routeId("foo").to("mock:foo");
            }
        };
    }
}

