/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUuidGeneratorTest {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUuidGeneratorTest.class);

    @Test
    public void testGenerateUUID() {
        DefaultUuidGenerator uuidGenerator = new DefaultUuidGenerator();
        String firstUUID = uuidGenerator.generateUuid();
        String secondUUID = uuidGenerator.generateUuid();
        Assertions.assertNotSame((Object)firstUUID, (Object)secondUUID);
    }

    @Test
    public void testPerformance() {
        DefaultUuidGenerator uuidGenerator = new DefaultUuidGenerator();
        StopWatch watch = new StopWatch();
        LOG.info("First id: {}", (Object)uuidGenerator.generateUuid());
        for (int i = 0; i < 500000; ++i) {
            uuidGenerator.generateUuid();
        }
        LOG.info("Last id: {}", (Object)uuidGenerator.generateUuid());
        LOG.info("Took {}", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true));
    }
}

