/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultProducerTemplateWithCustomCacheMaxSizeTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getGlobalOptions().put("CamelMaximumCachePoolSize", "200");
        return context;
    }

    @Test
    public void testCacheProducers() {
        ProducerTemplate template = this.context.createProducerTemplate();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
        for (int i = 0; i < 203; ++i) {
            Endpoint e = this.context.getEndpoint("seda:queue:" + i);
            template.sendBody(e, (Object)"Hello");
        }
        template.cleanUp();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> template.getCurrentCacheSize() == 200);
        Assertions.assertEquals((int)200, (int)template.getCurrentCacheSize(), (String)"Size should be 200");
        template.stop();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
    }

    @Test
    public void testInvalidSizeABC() {
        this.context.getGlobalOptions().put("CamelMaximumCachePoolSize", "ABC");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.createProducerTemplate(), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Property CamelMaximumCachePoolSize must be a positive number, was: ABC", (Object)e.getCause().getMessage());
    }

    @Test
    public void testInvalidSizeZero() {
        this.context.getGlobalOptions().put("CamelMaximumCachePoolSize", "0");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.createProducerTemplate(), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Property CamelMaximumCachePoolSize must be a positive number, was: 0", (Object)e.getCause().getMessage());
    }
}

