/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultProducerTemplateTest
extends ContextTestSupport {
    @Test
    public void testIn() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        Object result = this.template.requestBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertSame((Object)this.context, (Object)this.template.getCamelContext());
    }

    @Test
    public void testInTwice() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Bye World"});
        Object result = this.template.requestBody("direct:in", (Object)"Hello World");
        Object result2 = this.template.requestBody("direct:in", (Object)"Hello World Again");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertEquals((Object)"Bye World", (Object)result2);
        Assertions.assertSame((Object)this.context, (Object)this.template.getCamelContext());
    }

    @Test
    public void testInOut() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Bye World"});
        Object result = this.template.requestBody("direct:out", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye Bye World", (Object)result);
    }

    @Test
    public void testExceptionUsingBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.sendBody("direct:exception", (Object)"Hello World"), (String)"Should have thrown RuntimeCamelException");
        DefaultProducerTemplateTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)e.getCause().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionOnRequestBodyWithResponseType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.requestBody("direct:exception", (Object)"Hello World", Integer.class), (String)"Should have thrown RuntimeCamelException");
        DefaultProducerTemplateTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)e.getCause().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionUsingProcessor() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = this.template.send("direct:exception", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionUsingExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange exchange = this.context.getEndpoint("direct:exception").createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        Exchange out = this.template.send("direct:exception", exchange);
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequestExceptionUsingBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.requestBody("direct:exception", (Object)"Hello World"), (String)"Should have thrown RuntimeCamelException");
        DefaultProducerTemplateTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)e.getCause().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequestExceptionUsingProcessor() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = this.template.request("direct:exception", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequestExceptionUsingExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange exchange = this.context.getEndpoint("direct:exception").createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"Hello World");
        Exchange out = this.template.send("direct:exception", exchange);
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequestBody() {
        Integer out = (Integer)this.template.requestBody("direct:inout", (Object)"Hello", Integer.class);
        Assertions.assertEquals((Object)123, (Object)out);
        out = (Integer)this.template.requestBodyAndHeader("direct:inout", (Object)"Hello", "foo", (Object)"bar", Integer.class);
        Assertions.assertEquals((Object)123, (Object)out);
        HashMap headers = new HashMap();
        out = (Integer)this.template.requestBodyAndHeaders("direct:inout", (Object)"Hello", headers, Integer.class);
        Assertions.assertEquals((Object)123, (Object)out);
        Endpoint endpoint = this.context.getEndpoint("direct:inout");
        out = (Integer)this.template.requestBody(endpoint, (Object)"Hello", Integer.class);
        Assertions.assertEquals((Object)123, (Object)out);
        out = (Integer)this.template.requestBodyAndHeader(endpoint, (Object)"Hello", "foo", (Object)"bar", Integer.class);
        Assertions.assertEquals((Object)123, (Object)out);
        headers = new HashMap();
        out = (Integer)this.template.requestBodyAndHeaders(endpoint, (Object)"Hello", headers, Integer.class);
        Assertions.assertEquals((Object)123, (Object)out);
    }

    @Test
    public void testRequestUsingDefaultEndpoint() {
        DefaultProducerTemplate producer = new DefaultProducerTemplate((CamelContext)this.context, this.context.getEndpoint("direct:out"));
        producer.start();
        Object out = producer.requestBody((Object)"Hello");
        Assertions.assertEquals((Object)"Bye Bye World", (Object)out);
        out = producer.requestBodyAndHeader((Object)"Hello", "foo", (Object)123);
        Assertions.assertEquals((Object)"Bye Bye World", (Object)out);
        HashMap headers = new HashMap();
        out = producer.requestBodyAndHeaders((Object)"Hello", headers);
        Assertions.assertEquals((Object)"Bye Bye World", (Object)out);
        out = producer.requestBodyAndHeaders((Object)"Hello", null);
        Assertions.assertEquals((Object)"Bye Bye World", (Object)out);
        producer.stop();
    }

    @Test
    public void testSendUsingDefaultEndpoint() throws Exception {
        DefaultProducerTemplate producer = new DefaultProducerTemplate((CamelContext)this.context, this.context.getEndpoint("direct:in"));
        producer.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        producer.sendBody((Object)"Hello");
        producer.sendBodyAndHeader((Object)"Hello", "foo", (Object)123);
        HashMap headers = new HashMap();
        producer.sendBodyAndHeaders((Object)"Hello", headers);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((RouteDefinition)this.from("direct:in").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:out").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody((Object)"Bye Bye World");
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:exception").process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced exception by unit test");
                    }
                })).to("mock:result");
                this.from("direct:inout").transform((Expression)this.constant(123));
            }
        };
    }

    @Test
    public void testCacheProducers() {
        DefaultProducerTemplate template = new DefaultProducerTemplate((CamelContext)this.context);
        template.setMaximumCacheSize(500);
        template.start();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("seda:queue:" + i);
            template.sendBody(e, (Object)"Hello");
        }
        template.cleanUp();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> DefaultProducerTemplateTest.lambda$testCacheProducers$3((ProducerTemplate)template));
        Assertions.assertEquals((int)500, (int)template.getCurrentCacheSize(), (String)"Size should be 500");
        template.stop();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
    }

    @Test
    public void testCacheProducersFromContext() {
        ProducerTemplate template = this.context.createProducerTemplate(500);
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("seda:queue:" + i);
            template.sendBody(e, (Object)"Hello");
        }
        template.cleanUp();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> template.getCurrentCacheSize() == 500);
        Assertions.assertEquals((int)500, (int)template.getCurrentCacheSize(), (String)"Size should be 500");
        template.stop();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
    }

    private static /* synthetic */ Boolean lambda$testCacheProducers$3(ProducerTemplate template) throws Exception {
        return template.getCurrentCacheSize() == 500;
    }
}

