/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultProducerTemplateAsyncTest
extends ContextTestSupport {
    @Test
    public void testRequestAsync() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello");
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncSend("direct:start", (Exchange)exchange);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        Exchange result = (Exchange)future.get();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result.getIn().getBody());
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendAsyncProcessor() throws Exception {
        CompletableFuture future = this.template.asyncSend("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello");
            }
        });
        StopWatch watch = new StopWatch();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        Exchange result = (Exchange)future.get();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result.getIn().getBody());
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBody() {
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBody("direct:start", (Object)"Hello");
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        String result = (String)this.template.extractFutureBody((Future)future, String.class);
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result);
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBodyType() throws Exception {
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBody("direct:start", (Object)"Hello", String.class);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        String result = (String)future.get();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result);
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBodyAndHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)123);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        String result = (String)this.template.extractFutureBody((Future)future, String.class);
        this.assertMockEndpointsSatisfied();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result);
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBodyAndHeaderType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)123, String.class);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        String result = (String)future.get();
        this.assertMockEndpointsSatisfied();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result);
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBodyAndHeaders() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("bar", "cheese");
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBodyAndHeaders("direct:start", (Object)"Hello", headers);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        String result = (String)this.template.extractFutureBody((Future)future, String.class);
        this.assertMockEndpointsSatisfied();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result);
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBodyAndHeadersType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("bar", "cheese");
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBodyAndHeaders("direct:start", (Object)"Hello", headers, String.class);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        String result = (String)future.get();
        this.assertMockEndpointsSatisfied();
        long delta = watch.taken();
        Assertions.assertEquals((Object)"Hello World", (Object)result);
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncErrorWhenProcessing() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello");
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBody("direct:error", (Object)exchange);
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.extractFutureBody(future, Exchange.class), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Damn forced by unit test", (Object)e.getCause().getMessage());
        long delta = watch.taken();
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    @Test
    public void testRequestAsyncBodyErrorWhenProcessing() {
        StopWatch watch = new StopWatch();
        CompletableFuture future = this.template.asyncRequestBody("direct:error", (Object)"Hello");
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        Assertions.assertEquals((Object)"HiHi", (Object)echo);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.extractFutureBody(future, String.class), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Damn forced by unit test", (Object)e.getCause().getMessage());
        long delta = watch.taken();
        Assertions.assertTrue((delta > 50L ? 1 : 0) != 0, (String)("Should take longer than: " + delta));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").delay(200L).asyncDelayed().transform((Expression)this.body().append((Object)" World"))).to("mock:result");
                this.from("direct:error").delay(200L).asyncDelayed().process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Damn forced by unit test");
                    }
                });
                this.from("direct:echo").transform((Expression)this.body().append((Object)this.body()));
                this.from("direct:threads").threads(5).transform((Expression)this.body().append((Object)this.body()));
            }
        };
    }
}

