/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultMessageHeaderTest {
    private CamelContext camelContext;

    @BeforeEach
    protected void setUp() {
        this.camelContext = new DefaultCamelContext();
        this.camelContext.start();
    }

    @Test
    public void testLookupCaseAgnostic() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
    }

    @Test
    public void testLookupCaseAgnosticAddHeader() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
        msg.setHeader("bar", (Object)"beer");
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("bar"));
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("Bar"));
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("BAR"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
    }

    @Test
    public void testLookupCaseAgnosticAddHeader2() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
        msg.setHeader("bar", (Object)"beer");
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("BAR"));
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("bar"));
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("Bar"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
    }

    @Test
    public void testLookupCaseAgnosticAddHeaderRemoveHeader() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
        msg.setHeader("bar", (Object)"beer");
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("bar"));
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("Bar"));
        Assertions.assertEquals((Object)"beer", (Object)msg.getHeader("BAR"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
        msg.removeHeader("bar");
        Assertions.assertNull((Object)msg.getHeader("bar"));
        Assertions.assertNull((Object)msg.getHeader("unknown"));
    }

    @Test
    public void testSetWithDifferentCase() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        msg.setHeader("Foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)msg.getHeader("FOO"));
        Assertions.assertEquals((Object)"bar", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"bar", (Object)msg.getHeader("Foo"));
    }

    @Test
    public void testRemoveWithDifferentCase() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        msg.setHeader("Foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)msg.getHeader("FOO"));
        Assertions.assertEquals((Object)"bar", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"bar", (Object)msg.getHeader("Foo"));
        msg.removeHeader("FOO");
        Assertions.assertNull((Object)msg.getHeader("foo"));
        Assertions.assertNull((Object)msg.getHeader("Foo"));
        Assertions.assertNull((Object)msg.getHeader("FOO"));
        Assertions.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    @Test
    public void testRemoveHeaderWithNullValue() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", null);
        msg.removeHeader("tick");
        Assertions.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    @Test
    public void testRemoveHeadersWithWildcard() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        Assertions.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        Assertions.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        msg.removeHeaders("t*");
        Assertions.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    @Test
    public void testRemoveHeadersAllWithWildcard() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        Assertions.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        Assertions.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        msg.removeHeaders("*");
        Assertions.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    @Test
    public void testRemoveHeadersWithExclude() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tiack", (Object)"blaa");
        msg.setHeader("tiock", (Object)"blaaa");
        msg.setHeader("tiuck", (Object)"blaaaa");
        msg.removeHeaders("ti*", new String[]{"tiuck", "tiack"});
        Assertions.assertEquals((int)2, (int)msg.getHeaders().size());
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("tiack"));
        Assertions.assertEquals((Object)"blaaaa", (Object)msg.getHeader("tiuck"));
    }

    @Test
    public void testRemoveHeadersAllWithExclude() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        Assertions.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        Assertions.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        msg.removeHeaders("*", new String[]{"tick", "tock", "toe"});
        Assertions.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        Assertions.assertNull((Object)msg.getHeader("tack"));
        Assertions.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
    }

    @Test
    public void testRemoveHeadersWithWildcardInExclude() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("taick", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        msg.removeHeaders("*", new String[]{"ta*"});
        Assertions.assertEquals((int)2, (int)msg.getHeaders().size());
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("taick"));
    }

    @Test
    public void testRemoveHeadersWithNulls() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        msg.setHeader("taack", (Object)"blaaaa");
        Assertions.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        Assertions.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        Assertions.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        Assertions.assertEquals((Object)"blaaaa", (Object)msg.getHeader("taack"));
        msg.removeHeaders(null, new String[]{null, null, null});
        Assertions.assertFalse((boolean)msg.getHeaders().isEmpty());
    }

    @Test
    public void testRemoveHeadersWithNonExcludeHeaders() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        msg.removeHeaders("*", new String[]{"camels", "are", "fun"});
        Assertions.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    @Test
    public void testWithDefaults() {
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        msg.setExchange((Exchange)new DefaultExchange((CamelContext)new DefaultCamelContext()));
        Assertions.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo", (Object)"foo"));
        Assertions.assertEquals((Object)"cheese", (Object)msg.getHeader("foo", (Object)"foo", String.class));
        Assertions.assertNull((Object)msg.getHeader("beer"));
        Assertions.assertEquals((Object)"foo", (Object)msg.getHeader("beer", (Object)"foo"));
        Assertions.assertEquals((Integer)123, (Integer)((Integer)msg.getHeader("beer", (Object)"123", Integer.class)));
    }
}

