/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultInjectorTest {
    @Test
    public void testDefaultInjector() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        MyBean bean = (MyBean)context.getInjector().newInstance(MyBean.class);
        Object reply = bean.doSomething("World");
        Assertions.assertEquals((Object)"WorldWorld", (Object)reply);
    }

    @Test
    public void testDefaultInjectorFactory() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        MyOtherBean bean = (MyOtherBean)context.getInjector().newInstance(MyOtherBean.class, "getInstance");
        Object reply = bean.doSomething("World");
        Assertions.assertEquals((Object)"WorldWorld", (Object)reply);
    }

    public static class MyBean {
        @Produce(value="language:simple:${body}${body}")
        ProducerTemplate template;

        public Object doSomething(String body) {
            return this.template.requestBody((Object)body);
        }
    }

    public static class MyOtherBean {
        private static final MyOtherBean me = new MyOtherBean();

        public static MyOtherBean getInstance() {
            return me;
        }

        public Object doSomething(String body) {
            return body + body;
        }
    }
}

