/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.impl.engine.DefaultHeadersMapFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultHeadersMapFactoryTest {
    @Test
    public void testLookupCaseAgnostic() {
        Map map = new DefaultHeadersMapFactory().newMap();
        Assertions.assertNull(map.get("foo"));
        map.put("foo", "cheese");
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
    }

    @Test
    public void testConstructFromOther() {
        Map other = new DefaultHeadersMapFactory().newMap();
        other.put("Foo", "cheese");
        other.put("bar", 123);
        Map map = new DefaultHeadersMapFactory().newMap(other);
        Assertions.assertEquals((Object)"cheese", map.get("FOO"));
        Assertions.assertEquals((Object)"cheese", map.get("foo"));
        Assertions.assertEquals((Object)"cheese", map.get("Foo"));
        Assertions.assertEquals((Object)123, map.get("BAR"));
        Assertions.assertEquals((Object)123, map.get("bar"));
        Assertions.assertEquals((Object)123, map.get("BaR"));
    }

    @Test
    public void testIsInstance() {
        Map map = new DefaultHeadersMapFactory().newMap();
        Map other = new DefaultHeadersMapFactory().newMap(map);
        other.put("Foo", "cheese");
        other.put("bar", 123);
        Assertions.assertTrue((boolean)new DefaultHeadersMapFactory().isInstanceOf(map));
        Assertions.assertTrue((boolean)new DefaultHeadersMapFactory().isInstanceOf(other));
        Assertions.assertFalse((boolean)new DefaultHeadersMapFactory().isInstanceOf(new HashMap()));
    }
}

