/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashSet;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultHeaderFilterStrategyTest
extends ContextTestSupport {
    @Test
    public void testSimpleDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setAllowNullValues(true);
        Assertions.assertTrue((boolean)comp.isAllowNullValues());
        comp.setLowerCase(true);
        Assertions.assertTrue((boolean)comp.isLowerCase());
        comp.setCaseInsensitive(true);
        Assertions.assertTrue((boolean)comp.isCaseInsensitive());
        comp.setFilterOnMatch(false);
        Assertions.assertFalse((boolean)comp.isFilterOnMatch());
    }

    @Test
    public void testInFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setInFilter(set);
        Assertions.assertEquals(set, (Object)comp.getInFilter());
    }

    @Test
    public void testInFilterDoFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setInFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        Assertions.assertFalse((boolean)comp.applyFilterToExternalHeaders("bar", (Object)123, (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("foo", (Object)"cheese", (Exchange)exchange));
    }

    @Test
    public void testOutFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setOutFilter(set);
        Assertions.assertEquals(set, (Object)comp.getOutFilter());
    }

    @Test
    public void testOutFilterDoFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setOutFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        Assertions.assertFalse((boolean)comp.applyFilterToCamelHeaders("bar", (Object)123, (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("foo", (Object)"cheese", (Exchange)exchange));
    }

    @Test
    public void testOutReverseFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setFilterOnMatch(false);
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setOutFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("bar", (Object)123, (Exchange)exchange));
        Assertions.assertFalse((boolean)comp.applyFilterToCamelHeaders("foo", (Object)"cheese", (Exchange)exchange));
    }

    @Test
    public void testCaseInsensitiveHeaderNameDoFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setCaseInsensitive(true);
        HashSet<String> set = new HashSet<String>();
        set.add("Content-Type");
        comp.setOutFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("content-type", (Object)"application/xml");
        exchange.getIn().setHeader("Content-Type", (Object)"application/json");
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("content-type", (Object)"application/xml", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("Content-Type", (Object)"application/json", (Exchange)exchange));
    }

    @Test
    public void testOutStartsWith() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setOutFilterStartsWith(DefaultHeaderFilterStrategy.CAMEL_FILTER_STARTS_WITH);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        exchange.getIn().setHeader("CamelName", (Object)"Apache Camel");
        exchange.getIn().setHeader("camelVersion", (Object)"3.7");
        exchange.getIn().setHeader("org.apache.camel.id", (Object)"foo");
        Assertions.assertFalse((boolean)comp.applyFilterToCamelHeaders("bar", (Object)123, (Exchange)exchange));
        Assertions.assertFalse((boolean)comp.applyFilterToCamelHeaders("foo", (Object)"cheese", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("CamelName", (Object)"Apache Camel", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("camelVersion", (Object)"3.7", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("camelNextVersion", (Object)"3.8", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToCamelHeaders("org.apache.camel.component.seda.queueSize", (Object)"123", (Exchange)exchange));
    }

    @Test
    public void testInStartsWith() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setInFilterStartsWith(DefaultHeaderFilterStrategy.CAMEL_FILTER_STARTS_WITH);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        exchange.getIn().setHeader("CamelVersion", (Object)"3.7");
        exchange.getIn().setHeader("org.apache.camel.component.jetty.session", (Object)"true");
        Assertions.assertFalse((boolean)comp.applyFilterToExternalHeaders("bar", (Object)123, (Exchange)exchange));
        Assertions.assertFalse((boolean)comp.applyFilterToExternalHeaders("foo", (Object)"cheese", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("CamelVersion", (Object)"3.7", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("org.apache.camel.component.jetty.session", (Object)"true", (Exchange)exchange));
    }

    @Test
    public void testInStartsWithLowerCase() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setLowerCase(true);
        comp.setInFilterStartsWith(DefaultHeaderFilterStrategy.CAMEL_FILTER_STARTS_WITH);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        exchange.getIn().setHeader("caMElVersion", (Object)"3.7");
        exchange.getIn().setHeader("org.apache.CAMEL.component.jetty.session", (Object)"true");
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("caMElVersion", (Object)123, (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("cAmelResponseCode", (Object)503, (Exchange)exchange));
        Assertions.assertFalse((boolean)comp.applyFilterToExternalHeaders("bar", (Object)123, (Exchange)exchange));
        Assertions.assertFalse((boolean)comp.applyFilterToExternalHeaders("foo", (Object)"cheese", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("CamelVersion", (Object)"3.7", (Exchange)exchange));
        Assertions.assertTrue((boolean)comp.applyFilterToExternalHeaders("org.apache.camel.component.jetty.session", (Object)"true", (Exchange)exchange));
    }
}

