/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="camel.threads.virtual.enabled", matches="true", disabledReason="In case of Virtual Threads, ThreadPerTaskExecutor is created instead of ThreadPoolExecutor")
public class DefaultExecutorServiceManagerTest
extends ContextTestSupport {
    @Test
    public void testResolveThreadNameDefaultPattern() {
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertTrue((boolean)foo.startsWith("Camel (" + this.context.getName() + ") thread "));
        Assertions.assertTrue((boolean)foo.endsWith("foo"));
        Assertions.assertTrue((boolean)bar.startsWith("Camel (" + this.context.getName() + ") thread "));
        Assertions.assertTrue((boolean)bar.endsWith("bar"));
    }

    @Test
    public void testGetThreadNameCustomPattern() {
        this.context.getExecutorServiceManager().setThreadNamePattern("##counter# - #name#");
        Assertions.assertEquals((Object)"##counter# - #name#", (Object)this.context.getExecutorServiceManager().getThreadNamePattern());
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertTrue((boolean)foo.startsWith("#"));
        Assertions.assertTrue((boolean)foo.endsWith(" - foo"));
        Assertions.assertTrue((boolean)bar.startsWith("#"));
        Assertions.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    @Test
    public void testGetThreadNameCustomPatternCamelId() {
        this.context.getExecutorServiceManager().setThreadNamePattern("##camelId# - ##counter# - #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertTrue((boolean)foo.startsWith("#" + this.context.getName() + " - #"));
        Assertions.assertTrue((boolean)foo.endsWith(" - foo"));
        Assertions.assertTrue((boolean)bar.startsWith("#" + this.context.getName() + " - #"));
        Assertions.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    @Test
    public void testGetThreadNameCustomPatternWithDollar() {
        this.context.getExecutorServiceManager().setThreadNamePattern("Hello - #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo$bar");
        Assertions.assertEquals((Object)"Hello - foo$bar", (Object)foo);
    }

    @Test
    public void testGetThreadNameCustomPatternLongName() {
        this.context.getExecutorServiceManager().setThreadNamePattern("##counter# - #longName#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo?beer=Carlsberg");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertTrue((boolean)foo.startsWith("#"));
        Assertions.assertTrue((boolean)foo.endsWith(" - foo?beer=Carlsberg"));
        Assertions.assertTrue((boolean)bar.startsWith("#"));
        Assertions.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    @Test
    public void testGetThreadNameCustomPatternWithParameters() {
        this.context.getExecutorServiceManager().setThreadNamePattern("##counter# - #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo?beer=Carlsberg");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertTrue((boolean)foo.startsWith("#"));
        Assertions.assertTrue((boolean)foo.endsWith(" - foo"));
        Assertions.assertTrue((boolean)bar.startsWith("#"));
        Assertions.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    @Test
    public void testGetThreadNameCustomPatternNoCounter() {
        this.context.getExecutorServiceManager().setThreadNamePattern("Cool #name#");
        String foo = this.context.getExecutorServiceManager().resolveThreadName("foo");
        String bar = this.context.getExecutorServiceManager().resolveThreadName("bar");
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertEquals((Object)"Cool foo", (Object)foo);
        Assertions.assertEquals((Object)"Cool bar", (Object)bar);
    }

    @Test
    public void testGetThreadNameCustomPatternInvalid() {
        this.context.getExecutorServiceManager().setThreadNamePattern("Cool #xxx#");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.getExecutorServiceManager().resolveThreadName("foo"), (String)"Should thrown an exception");
        Assertions.assertEquals((Object)"Pattern is invalid: [Cool #xxx#] in resolved thread name: [Cool #xxx#]", (Object)e.getMessage());
        this.context.getExecutorServiceManager().setThreadNamePattern("Camel Thread #counter# - #name#");
    }

    @Test
    public void testDefaultThreadPool() {
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        Assertions.assertFalse((boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        Assertions.assertEquals((int)10, (int)executor.getCorePoolSize());
        Assertions.assertEquals((int)20, (int)executor.getMaximumPoolSize());
        Assertions.assertEquals((long)60L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)1000, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        Assertions.assertTrue((boolean)myPool.isShutdown());
    }

    @Test
    public void testDefaultUnboundedQueueThreadPool() {
        ThreadPoolProfile custom = new ThreadPoolProfile("custom");
        custom.setPoolSize(Integer.valueOf(10));
        custom.setMaxPoolSize(Integer.valueOf(30));
        custom.setKeepAliveTime(Long.valueOf(50L));
        custom.setMaxQueueSize(Integer.valueOf(Integer.MAX_VALUE));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(custom);
        Assertions.assertTrue((boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        Assertions.assertFalse((boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        Assertions.assertEquals((int)10, (int)executor.getCorePoolSize());
        Assertions.assertEquals((int)30, (int)executor.getMaximumPoolSize());
        Assertions.assertEquals((long)50L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        Assertions.assertTrue((boolean)myPool.isShutdown());
    }

    @Test
    public void testDefaultNoMaxQueueThreadPool() {
        ThreadPoolProfile custom = new ThreadPoolProfile("custom");
        custom.setPoolSize(Integer.valueOf(10));
        custom.setMaxPoolSize(Integer.valueOf(30));
        custom.setKeepAliveTime(Long.valueOf(50L));
        custom.setMaxQueueSize(Integer.valueOf(0));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(custom);
        Assertions.assertTrue((boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        Assertions.assertFalse((boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        Assertions.assertEquals((int)10, (int)executor.getCorePoolSize());
        Assertions.assertEquals((int)30, (int)executor.getMaximumPoolSize());
        Assertions.assertEquals((long)50L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        Assertions.assertTrue((boolean)myPool.isShutdown());
    }

    @Test
    public void testCustomDefaultThreadPool() {
        ThreadPoolProfile custom = new ThreadPoolProfile("custom");
        custom.setKeepAliveTime(Long.valueOf(20L));
        custom.setMaxPoolSize(Integer.valueOf(40));
        custom.setPoolSize(Integer.valueOf(5));
        custom.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(custom);
        Assertions.assertTrue((boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
        Assertions.assertFalse((boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        Assertions.assertEquals((int)5, (int)executor.getCorePoolSize());
        Assertions.assertEquals((int)40, (int)executor.getMaximumPoolSize());
        Assertions.assertEquals((long)20L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)2000, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        Assertions.assertTrue((boolean)myPool.isShutdown());
    }

    @Test
    public void testGetThreadPoolProfile() {
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        Assertions.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
    }

    @Test
    public void testTwoGetThreadPoolProfile() {
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        ThreadPoolProfile bar = new ThreadPoolProfile("bar");
        bar.setKeepAliveTime(Long.valueOf(40L));
        bar.setMaxPoolSize(Integer.valueOf(5));
        bar.setPoolSize(Integer.valueOf(1));
        bar.setMaxQueueSize(Integer.valueOf(100));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(bar);
        Assertions.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        Assertions.assertSame((Object)bar, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("bar"));
        Assertions.assertNotSame((Object)foo, (Object)bar);
        Assertions.assertFalse((boolean)this.context.getExecutorServiceManager().getThreadPoolProfile("foo").isDefaultProfile());
        Assertions.assertFalse((boolean)this.context.getExecutorServiceManager().getThreadPoolProfile("bar").isDefaultProfile());
    }

    @Test
    public void testGetThreadPoolProfileInheritDefaultValues() {
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setMaxPoolSize(Integer.valueOf(40));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        Assertions.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceManager().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        Assertions.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)10, (int)tp.getCorePoolSize());
        Assertions.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"CallerRuns", (Object)tp.getRejectedExecutionHandler().toString());
    }

    @Test
    public void testGetThreadPoolProfileInheritCustomDefaultValues() {
        ThreadPoolProfile newDefault = new ThreadPoolProfile("newDefault");
        newDefault.setKeepAliveTime(Long.valueOf(30L));
        newDefault.setMaxPoolSize(Integer.valueOf(50));
        newDefault.setPoolSize(Integer.valueOf(5));
        newDefault.setMaxQueueSize(Integer.valueOf(2000));
        newDefault.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(newDefault);
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setMaxPoolSize(Integer.valueOf(25));
        foo.setPoolSize(Integer.valueOf(1));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        Assertions.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceManager().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        Assertions.assertEquals((int)25, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)1, (int)tp.getCorePoolSize());
        Assertions.assertEquals((long)30L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"Abort", (Object)tp.getRejectedExecutionHandler().toString());
    }

    @Test
    public void testGetThreadPoolProfileInheritCustomDefaultValues2() {
        ThreadPoolProfile newDefault = new ThreadPoolProfile("newDefault");
        newDefault.setMaxPoolSize(Integer.valueOf(50));
        this.context.getExecutorServiceManager().setDefaultThreadPoolProfile(newDefault);
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setPoolSize(Integer.valueOf(1));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        Assertions.assertSame((Object)foo, (Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceManager().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        Assertions.assertEquals((int)1, (int)tp.getCorePoolSize());
        Assertions.assertEquals((int)50, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"CallerRuns", (Object)tp.getRejectedExecutionHandler().toString());
    }

    @Test
    public void testNewThreadPoolProfile() {
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "Cool", foo);
        Assertions.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        Assertions.assertEquals((long)20L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)5, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewThreadPoolProfileById() {
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "Cool", "foo");
        Assertions.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        Assertions.assertEquals((long)20L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)5, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewThreadPoolMinMax() {
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "Cool", 5, 10);
        Assertions.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        Assertions.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)10, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)5, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewFixedThreadPool() {
        ExecutorService pool = this.context.getExecutorServiceManager().newFixedThreadPool((Object)this, "Cool", 5);
        Assertions.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        Assertions.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS), (String)"keepAliveTime");
        Assertions.assertEquals((int)5, (int)tp.getMaximumPoolSize(), (String)"maximumPoolSize");
        Assertions.assertEquals((int)5, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewSingleThreadExecutor() {
        ExecutorService pool = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "Cool");
        Assertions.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        Assertions.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS), (String)"keepAliveTime");
        Assertions.assertEquals((int)1, (int)tp.getMaximumPoolSize(), (String)"maximumPoolSize");
        Assertions.assertEquals((int)1, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewScheduledThreadPool() {
        ScheduledExecutorService pool = this.context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "Cool", 5);
        Assertions.assertNotNull((Object)pool);
        SizedScheduledExecutorService tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(SizedScheduledExecutorService.class, pool);
        Assertions.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)5, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewSingleThreadScheduledExecutor() {
        ScheduledExecutorService pool = this.context.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "Cool");
        Assertions.assertNotNull((Object)pool);
        SizedScheduledExecutorService tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(SizedScheduledExecutorService.class, pool);
        Assertions.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)1, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewCachedThreadPool() {
        ExecutorService pool = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "Cool");
        Assertions.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        Assertions.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)0, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewScheduledThreadPoolProfileById() {
        Assertions.assertNull((Object)this.context.getExecutorServiceManager().getThreadPoolProfile("foo"));
        ThreadPoolProfile foo = new ThreadPoolProfile("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceManager().registerThreadPoolProfile(foo);
        ScheduledExecutorService pool = this.context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "Cool", "foo");
        Assertions.assertNotNull((Object)pool);
        SizedScheduledExecutorService tp = DefaultExecutorServiceManagerTest.assertIsInstanceOf(SizedScheduledExecutorService.class, pool);
        Assertions.assertEquals((long)0L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)tp.getMaximumPoolSize());
        Assertions.assertEquals((int)5, (int)tp.getCorePoolSize());
        Assertions.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)tp.isShutdown());
    }

    @Test
    public void testNewThread() {
        Thread thread = this.context.getExecutorServiceManager().newThread("Cool", new Runnable(){

            @Override
            public void run() {
            }
        });
        Assertions.assertNotNull((Object)thread);
        Assertions.assertTrue((boolean)thread.isDaemon());
        Assertions.assertTrue((boolean)thread.getName().contains("Cool"));
    }

    @Disabled(value="This is a manual test, by looking at the logs")
    @Test
    public void testLongShutdownOfThreadPool() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutorService pool = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "Cool");
        pool.execute(new Runnable(){

            @Override
            public void run() {
                DefaultExecutorServiceManagerTest.this.log.info("Starting thread");
                try {
                    latch.await(42L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DefaultExecutorServiceManagerTest.this.log.info("Existing thread");
            }
        });
        Thread.sleep(3000L);
        this.context.getExecutorServiceManager().shutdown(pool);
        Assertions.assertTrue((boolean)pool.isShutdown());
        Assertions.assertTrue((boolean)pool.isTerminated());
    }

    @Test
    public void testThreadFactoryListener() {
        ThreadFactory myFactory = r -> new Thread(r, "MyFactory");
        this.context.getExecutorServiceManager().addThreadFactoryListener(factory -> myFactory);
        Thread thread = this.context.getExecutorServiceManager().newThread("Cool", () -> {});
        Assertions.assertNotNull((Object)thread);
        Assertions.assertTrue((boolean)thread.isDaemon());
        Assertions.assertTrue((boolean)thread.getName().contains("MyFactory"));
    }

    @Test
    public void testThreadFactoryListenerViaRegistry() {
        DefaultCamelContext c = new DefaultCamelContext();
        ThreadFactory myFactory = r -> new Thread(r, "MyFactory2");
        ExecutorServiceManager.ThreadFactoryListener listener = factory -> myFactory;
        c.getRegistry().bind("myListener", (Object)listener);
        c.start();
        Thread thread = c.getExecutorServiceManager().newThread("Cool2", () -> {});
        Assertions.assertNotNull((Object)thread);
        Assertions.assertTrue((boolean)thread.isDaemon());
        Assertions.assertTrue((boolean)thread.getName().contains("MyFactory2"));
        c.stop();
    }
}

