/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.TypeConversionException;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultExchangeTest
extends ExchangeTestSupport {
    private static final String SAFE_PROPERTY = "SAFE_PROPERTY";
    private static final String UNSAFE_PROPERTY = "UNSAFE_PROPERTY";

    @Test
    public void testBody() throws Exception {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.exchange.getIn().getBody());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getBody());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getBody(String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getMandatoryBody());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getMandatoryBody(String.class));
    }

    @Test
    public void testMandatoryBody() throws Exception {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.exchange.getIn().getBody());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getBody());
        org.junit.jupiter.api.Assertions.assertThrows(TypeConversionException.class, () -> org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getIn().getBody(Integer.class)), (String)"Should have thrown a TypeConversionException");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getMandatoryBody());
        org.junit.jupiter.api.Assertions.assertThrows(InvalidPayloadException.class, () -> this.exchange.getIn().getMandatoryBody(Integer.class), (String)"Should have thrown an InvalidPayloadException");
    }

    @Test
    public void testExceptionAsType() {
        this.exchange.setException((Throwable)RuntimeCamelException.wrapRuntimeCamelException((Throwable)new ConnectException("Cannot connect to remote server")));
        ConnectException ce = (ConnectException)this.exchange.getException(ConnectException.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)ce);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Cannot connect to remote server", (Object)ce.getMessage());
        IOException ie = (IOException)this.exchange.getException(IOException.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)ie);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Cannot connect to remote server", (Object)ie.getMessage());
        Exception e = (Exception)this.exchange.getException(Exception.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)e);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Cannot connect to remote server", (Object)e.getMessage());
        RuntimeCamelException rce = (RuntimeCamelException)((Object)this.exchange.getException(RuntimeCamelException.class));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)rce));
        org.junit.jupiter.api.Assertions.assertNotSame((Object)"Cannot connect to remote server", (Object)rce.getMessage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Cannot connect to remote server", (Object)rce.getCause().getMessage());
    }

    @Test
    public void testHeader() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.exchange.getIn().getHeaders());
        org.junit.jupiter.api.Assertions.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Integer)123, (Integer)((Integer)this.exchange.getIn().getHeader("bar", Integer.class)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"123", (Object)this.exchange.getIn().getHeader("bar", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar", (Object)234));
        org.junit.jupiter.api.Assertions.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar", () -> 456));
        org.junit.jupiter.api.Assertions.assertEquals((Object)456, (Object)this.exchange.getIn().getHeader("baz", () -> 456));
        org.junit.jupiter.api.Assertions.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar", (Object)234));
        org.junit.jupiter.api.Assertions.assertEquals((Integer)123, (Integer)((Integer)this.exchange.getIn().getHeader("bar", (Object)234, Integer.class)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"123", (Object)this.exchange.getIn().getHeader("bar", (Object)"234", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"123", (Object)this.exchange.getIn().getHeader("bar", () -> "456", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"456", (Object)this.exchange.getIn().getHeader("baz", () -> "456", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)234, (Object)this.exchange.getIn().getHeader("cheese", (Object)234));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"234", (Object)this.exchange.getIn().getHeader("cheese", (Object)234, String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"456", (Object)this.exchange.getIn().getHeader("cheese", () -> 456, String.class));
    }

    @Test
    public void testProperty() {
        this.exchange.removeProperty("foobar");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("beer"));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("beer", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.exchange.getProperty("beer", Boolean.TYPE));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("beer", Boolean.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit", (Object)"banana", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getProperty("beer", (Object)"banana", String.class));
    }

    @Test
    public void testVariable() {
        this.exchange.removeVariable("cheese");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
        this.exchange.setVariable("fruit", (Object)"apple");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasVariables());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getVariable("fruit"));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getVariable("beer"));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getVariable("beer", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.exchange.getVariable("beer", Boolean.TYPE));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getVariable("beer", Boolean.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getVariable("fruit", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getVariable("fruit", (Object)"banana", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getVariable("beer", (Object)"banana", String.class));
    }

    @Test
    public void testGlobalVariable() {
        this.exchange.removeVariable("cheese");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
        this.exchange.setVariable("fruit", (Object)"apple");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasVariables());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getVariable("fruit"));
        this.exchange.setVariable("global:myGlob", (Object)"myGlobVar");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"myGlobVar", (Object)this.exchange.getVariable("global:myGlob"));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getVariable("myGlob"));
        this.exchange.removeVariable("fruit");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
    }

    @Test
    public void testRemoveProperties() {
        this.exchange.removeProperty("foobar");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("zone", (Object)"Africa");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone"));
        this.exchange.removeProperties("fr*");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.exchange.getProperties().size());
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("fruit", String.class));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("fruit1", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone", String.class));
    }

    @Test
    public void testRemoveVariables() {
        this.exchange.removeVariable("cheese");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
        this.exchange.setVariable("fruit", (Object)"apple");
        this.exchange.setVariable("fruit1", (Object)"banana");
        this.exchange.setVariable("zone", (Object)"Africa");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasVariables());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getVariable("fruit"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getVariable("fruit1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getVariable("zone"));
        this.exchange.setVariable("global:myGlob", (Object)"myGlobVar");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"myGlobVar", (Object)this.exchange.getVariable("global:myGlob"));
        this.exchange.removeVariable("global:myGlob");
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getVariable("global:myGlob"));
    }

    @Test
    public void testRemoveAllProperties() {
        this.exchange.removeProperty("foobar");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("zone", (Object)"Africa");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        this.exchange.removeProperties("*");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.exchange.getProperties().size());
    }

    @Test
    public void testRemoveAllVariables() {
        this.exchange.removeVariable("cheese");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
        this.exchange.setVariable("fruit", (Object)"apple");
        this.exchange.setVariable("fruit1", (Object)"banana");
        this.exchange.setVariable("zone", (Object)"Africa");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasVariables());
        this.exchange.removeVariable("*");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.exchange.getVariables().size());
    }

    @Test
    public void testRemovePropertiesWithExclusion() {
        this.exchange.removeProperty("foobar");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("fruit2", (Object)"peach");
        this.exchange.setProperty("zone", (Object)"Africa");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"peach", (Object)this.exchange.getProperty("fruit2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone"));
        this.exchange.removeProperties("fr*", new String[]{"fruit1", "fruit2"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.exchange.getProperties().size());
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("fruit", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"peach", (Object)this.exchange.getProperty("fruit2", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone", String.class));
    }

    @Test
    public void testRemovePropertiesPatternWithAllExcluded() {
        this.exchange.removeProperty("foobar");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("fruit2", (Object)"peach");
        this.exchange.setProperty("zone", (Object)"Africa");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"peach", (Object)this.exchange.getProperty("fruit2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone"));
        this.exchange.removeProperties("fr*", new String[]{"fruit", "fruit1", "fruit2", "zone"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.exchange.hasProperties());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.exchange.getProperties().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"peach", (Object)this.exchange.getProperty("fruit2", String.class));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone", String.class));
    }

    @Test
    public void testRemoveInternalProperties() {
        this.exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)"iso-8859-1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"iso-8859-1", (Object)this.exchange.getProperty(ExchangePropertyKey.CHARSET_NAME));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"iso-8859-1", (Object)this.exchange.getProperty("CamelCharsetName"));
        this.exchange.removeProperty(ExchangePropertyKey.CHARSET_NAME);
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty(ExchangePropertyKey.CHARSET_NAME));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty("CamelCharsetName"));
        this.exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)"iso-8859-1");
        this.exchange.setProperty(ExchangePropertyKey.AGGREGATED_SIZE, (Object)"1");
        this.exchange.setProperty(ExchangePropertyKey.AGGREGATED_TIMEOUT, (Object)"2");
        this.exchange.removeProperties("CamelAggregated*");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"iso-8859-1", (Object)this.exchange.getProperty(ExchangePropertyKey.CHARSET_NAME));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty(ExchangePropertyKey.AGGREGATED_SIZE));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty(ExchangePropertyKey.AGGREGATED_TIMEOUT));
        this.exchange.removeProperties("*");
        org.junit.jupiter.api.Assertions.assertNull((Object)this.exchange.getProperty(ExchangePropertyKey.CHARSET_NAME));
    }

    @Test
    public void testAllProperties() {
        this.exchange.removeProperties("*");
        this.exchange.setProperty("foo", (Object)123);
        this.exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)"seda:bar");
        this.exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)"iso-8859-1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.exchange.getProperties().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.exchange.getExchangeExtension().getInternalProperties().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.exchange.getAllProperties().size());
    }

    @Test
    public void testCopyExchangeWithVariables() {
        this.exchange.setVariable("beer", (Object)"Carlsberg");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.exchange.getVariables().size());
        Exchange copy = this.exchange.copy();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)copy.hasVariables());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)copy.getVariables().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"gauda", (Object)copy.getVariable("cheese"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Carlsberg", (Object)copy.getVariable("beer"));
        this.exchange.setVariable("beer", (Object)"Heineken");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Carlsberg", (Object)copy.getVariable("beer"));
        this.exchange.removeVariable("beer");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.exchange.getVariables().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Carlsberg", (Object)copy.getVariable("beer"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)copy.getVariables().size());
        this.exchange.removeVariable("*");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.exchange.hasVariables());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)copy.hasVariables());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)copy.getVariables().size());
    }

    @Test
    public void testInType() {
        this.exchange.setIn((Message)new MyMessage((CamelContext)this.context));
        MyMessage my = (MyMessage)((Object)this.exchange.getIn(MyMessage.class));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)my));
    }

    @Test
    public void testOutType() {
        this.exchange.setOut((Message)new MyMessage((CamelContext)this.context));
        MyMessage my = (MyMessage)((Object)this.exchange.getOut(MyMessage.class));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)my));
    }

    @Test
    public void testCopy() {
        DefaultExchange sourceExchange = new DefaultExchange((CamelContext)this.context);
        MyMessage sourceIn = new MyMessage((CamelContext)this.context);
        sourceExchange.setIn((Message)sourceIn);
        Exchange destExchange = sourceExchange.copy();
        Message destIn = destExchange.getIn();
        org.junit.jupiter.api.Assertions.assertEquals(((Object)((Object)sourceIn)).getClass(), (Object)destIn.getClass(), (String)"Dest message should be of the same type as source message");
    }

    @Test
    public void testExchangeSafeCopy() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        SafeProperty property = new SafeProperty();
        UnsafeProperty unsafeProperty = new UnsafeProperty();
        exchange.getExchangeExtension().setSafeCopyProperty(SAFE_PROPERTY, (SafeCopyProperty)property);
        exchange.setProperty(UNSAFE_PROPERTY, (Object)unsafeProperty);
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        Assertions.assertThat((Object)copy.getProperty(SAFE_PROPERTY)).isNotSameAs((Object)property);
        Assertions.assertThat((Object)copy.getProperty(UNSAFE_PROPERTY)).isSameAs((Object)unsafeProperty);
    }

    public static class MyMessage
    extends DefaultMessage {
        public MyMessage(CamelContext camelContext) {
            super(camelContext);
        }

        public MyMessage newInstance() {
            return new MyMessage(this.getCamelContext());
        }
    }

    private static final class SafeProperty
    implements SafeCopyProperty {
        private SafeProperty() {
        }

        public SafeProperty safeCopy() {
            return new SafeProperty();
        }
    }

    private static class UnsafeProperty {
        private UnsafeProperty() {
        }
    }
}

