/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultExchangeHolderTest
extends ContextTestSupport {
    private String id;

    @Test
    public void testMarshal() {
        DefaultExchangeHolder holder = this.createHolder(true);
        Assertions.assertNotNull((Object)holder);
        Assertions.assertNotNull((Object)holder.toString());
    }

    @Test
    public void testNoProperties() {
        DefaultExchangeHolder holder = this.createHolder(false);
        Assertions.assertNotNull((Object)holder);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)"Bye World", (Object)exchange.getOut().getBody());
        Assertions.assertEquals((Object)123, (Object)exchange.getIn().getHeader("foo"));
        Assertions.assertNull((Object)exchange.getProperty("bar"));
        Assertions.assertNull((Object)exchange.getProperty("myVar"));
        Assertions.assertNull((Object)exchange.getProperty("myOtherVar"));
    }

    @Test
    public void testUnmarshal() {
        this.id = null;
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)this.createHolder(true));
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)"Bye World", (Object)exchange.getOut().getBody());
        Assertions.assertEquals((Object)123, (Object)exchange.getIn().getHeader("foo"));
        Assertions.assertEquals((Object)"Hi Camel", (Object)exchange.getIn().getHeader("CamelFoo"));
        Assertions.assertEquals((Object)444, (Object)exchange.getProperty("bar"));
        Assertions.assertEquals((Object)555, (Object)exchange.getProperty("CamelBar"));
        Assertions.assertEquals((Object)666, (Object)exchange.getVariable("myVar"));
        Assertions.assertEquals((Object)"cheese", (Object)exchange.getVariable("myOtherVar"));
        Assertions.assertEquals((Object)this.id, (Object)exchange.getExchangeId());
    }

    @Test
    public void testSkipNonSerializableData() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", (Object)new MyFoo("Tiger"));
        exchange.getIn().setHeader("Bar", (Object)123);
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        Assertions.assertNull((Object)exchange.getIn().getHeader("Foo"));
    }

    @Test
    public void testSkipNonSerializableDataFromList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("I am okay");
        list.add(new MyFoo("Tiger"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", list);
        exchange.getIn().setHeader("Bar", (Object)123);
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        Assertions.assertNull((Object)exchange.getIn().getHeader("Foo"));
    }

    @Test
    public void testSkipNonSerializableDataFromMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("A", "I am okay");
        map.put("B", new MyFoo("Tiger"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", map);
        exchange.getIn().setHeader("Bar", (Object)123);
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        Assertions.assertNull((Object)exchange.getIn().getHeader("Foo"));
    }

    @Test
    public void testFileNotSupported() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new File("src/test/resources/log4j2.properties"));
        Assertions.assertThrows(RuntimeExchangeException.class, () -> DefaultExchangeHolderTest.lambda$testFileNotSupported$0((Exchange)exchange), (String)"Should have thrown exception");
    }

    @Test
    public void testCaughtException() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("I am okay");
        list.add(new MyFoo("Tiger"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("Foo", list);
        exchange.getIn().setHeader("Bar", (Object)123);
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("Forced"));
        DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
        exchange = new DefaultExchange((CamelContext)this.context);
        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)123, (Object)exchange.getIn().getHeader("Bar"));
        Assertions.assertNull((Object)exchange.getIn().getHeader("Foo"));
        Assertions.assertNotNull((Object)exchange.getProperty("CamelExceptionCaught"));
        Assertions.assertEquals((Object)"Forced", (Object)((Exception)exchange.getProperty("CamelExceptionCaught", Exception.class)).getMessage());
    }

    private DefaultExchangeHolder createHolder(boolean includeProperties) {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        this.id = exchange.getExchangeId();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getIn().setHeader("foo", (Object)123);
        exchange.getIn().setHeader("CamelFoo", (Object)"Hi Camel");
        exchange.setProperty("bar", (Object)444);
        exchange.setProperty("CamelBar", (Object)555);
        exchange.setVariable("myVar", (Object)666);
        exchange.setVariable("myOtherVar", (Object)"cheese");
        exchange.getOut().setBody((Object)"Bye World");
        return DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)includeProperties, (boolean)false);
    }

    private static /* synthetic */ void lambda$testFileNotSupported$0(Exchange exchange) throws Throwable {
        DefaultExchangeHolder.marshal((Exchange)exchange);
    }

    private static final class MyFoo {
        private final String foo;

        private MyFoo(String foo) {
            this.foo = foo;
        }

        public String getFoo() {
            return this.foo;
        }
    }
}

