/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DummyLifecycleStrategy;
import org.apache.camel.impl.engine.DefaultEndpointRegistry;
import org.apache.camel.impl.engine.SimpleCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.LifecycleStrategy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultEndpointRegistryTest {
    @Test
    public void testRemoveEndpoint() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.start();
        ctx.getEndpoint("direct:one");
        Endpoint e = ctx.getEndpoint("direct:two");
        ctx.getEndpoint("direct:three");
        Assertions.assertEquals((int)3, (int)ctx.getEndpoints().size());
        ctx.removeEndpoint(e);
        Assertions.assertEquals((int)2, (int)ctx.getEndpoints().size());
    }

    @Test
    public void testRemoveEndpointWithHash() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.start();
        ctx.getEndpoint("direct:one");
        Endpoint e = ctx.getEndpoint("stub:me?bean=#myBean");
        ctx.getEndpoint("direct:three");
        Assertions.assertEquals((int)3, (int)ctx.getEndpoints().size());
        ctx.removeEndpoint(e);
        Assertions.assertEquals((int)2, (int)ctx.getEndpoints().size());
    }

    @Test
    public void testRemoveEndpointToD() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").toD().cacheSize(10).uri("mock:${header.foo}");
            }
        });
        final AtomicInteger cnt = new AtomicInteger();
        ctx.addLifecycleStrategy((LifecycleStrategy)new DummyLifecycleStrategy(){

            @Override
            public void onEndpointRemove(Endpoint endpoint) {
                cnt.incrementAndGet();
            }
        });
        ctx.start();
        Assertions.assertEquals((int)0, (int)cnt.get());
        Assertions.assertEquals((int)1, (int)ctx.getEndpoints().size());
        FluentProducerTemplate template = ctx.createFluentProducerTemplate();
        for (int i = 0; i < 100; ++i) {
            template.withBody((Object)"Hello").withHeader("foo", (Object)Integer.toString(i)).to("direct:start").send();
        }
        Awaitility.await().untilAsserted(() -> Assertions.assertEquals((int)11, (int)ctx.getEndpoints().size()));
        Assertions.assertEquals((int)90, (int)cnt.get());
        ctx.stop();
    }

    @Test
    public void testMigration() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.start();
        DefaultEndpointRegistry reg = (DefaultEndpointRegistry)ctx.getEndpointRegistry();
        ctx.getEndpoint("direct:error");
        Assertions.assertTrue((boolean)reg.isDynamic("direct:error"));
        ctx.removeEndpoints("direct:error");
        ctx.getCamelContextExtension().setupRoutes(false);
        ctx.getEndpoint("direct:error");
        Assertions.assertTrue((boolean)reg.isStatic("direct:error"));
    }

    @Test
    public void testMigrationRoute() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:error").maximumRedeliveries(2).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:error").routeId("error").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:dead?level=ERROR")).to("mock:error")).to("file:error");
            }
        });
        ctx.start();
        EndpointRegistry reg = ctx.getEndpointRegistry();
        Assertions.assertTrue((boolean)reg.isStatic("direct:error"));
        Assertions.assertTrue((boolean)reg.isStatic("mock:error"));
        Assertions.assertTrue((boolean)reg.isStatic("file:error"));
    }

    @Test
    public void testConcurrency() throws InterruptedException {
        SimpleCamelContext context = new SimpleCamelContext();
        context.start();
        ProducerTemplate producerTemplate = context.createProducerTemplate();
        EndpointRegistry endpointRegistry = context.getEndpointRegistry();
        int nThreads = 4;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        int iterations = 500;
        for (int j = 0; j < iterations; ++j) {
            CountDownLatch allThreadCompletionSemaphore = new CountDownLatch(nThreads);
            for (int i = 0; i < nThreads; ++i) {
                executorService.submit(() -> {
                    producerTemplate.requestBody("controlbus:route?routeId=route1&action=ACTION_STATUS&loggingLevel=off", null, ServiceStatus.class);
                    producerTemplate.requestBody("controlbus:route?routeId=route2&action=ACTION_STATUS&loggingLevel=off", null, ServiceStatus.class);
                    producerTemplate.requestBody("controlbus:route?routeId=route3&action=ACTION_STATUS&loggingLevel=off", null, ServiceStatus.class);
                    producerTemplate.requestBody("controlbus:route?routeId=route4&action=ACTION_STATUS&loggingLevel=off", null, ServiceStatus.class);
                    producerTemplate.requestBody("controlbus:route?routeId=route5&action=ACTION_STATUS&loggingLevel=off", null, ServiceStatus.class);
                    allThreadCompletionSemaphore.countDown();
                });
            }
            allThreadCompletionSemaphore.await();
            Assertions.assertNotNull((Object)endpointRegistry.values().toArray());
        }
        executorService.shutdown();
    }
}

