/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.StopWatch;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultConsumerTemplateTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_SEDA_CONSUMER = "foo" + String.valueOf(UUID.randomUUID());
    private DefaultConsumerTemplate consumer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.consumer = new DefaultConsumerTemplate((CamelContext)this.context);
        this.consumer.start();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.consumer.stop();
        super.tearDown();
    }

    @Test
    public void testConsumeReceive() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Exchange out = this.consumer.receive("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
        Assertions.assertSame((Object)this.context, (Object)this.consumer.getCamelContext());
    }

    @Test
    public void testConsumeTwiceReceive() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Exchange out = this.consumer.receive("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Bye");
        out = this.consumer.receive("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Bye", (Object)out.getIn().getBody());
    }

    @Test
    public void testConsumeReceiveNoWait() {
        Exchange out = this.consumer.receiveNoWait("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertNull((Object)out);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            Exchange foo = this.consumer.receiveNoWait("seda:" + TEST_SEDA_CONSUMER);
            if (foo != null) {
                Assertions.assertEquals((Object)"Hello", (Object)foo.getIn().getBody());
            }
            return foo != null;
        });
    }

    @Test
    public void testConsumeReceiveTimeout() {
        StopWatch watch = new StopWatch();
        Exchange out = this.consumer.receive("seda:" + TEST_SEDA_CONSUMER, 1000L);
        Assertions.assertNull((Object)out);
        long delta = watch.taken();
        Assertions.assertTrue((delta < 1500L ? 1 : 0) != 0, (String)("Should take about 1 sec: " + delta));
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        out = this.consumer.receive("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    @Test
    public void testConsumeReceiveBody() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Object body = this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeTwiceReceiveBody() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Object body = this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertEquals((Object)"Hello", (Object)body);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Bye");
        body = this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertEquals((Object)"Bye", (Object)body);
    }

    @Test
    public void testConsumeReceiveBodyNoWait() {
        Object body = this.consumer.receiveBodyNoWait("seda:" + TEST_SEDA_CONSUMER);
        Assertions.assertNull((Object)body);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Object foo = this.consumer.receiveBodyNoWait("seda:" + TEST_SEDA_CONSUMER);
            Assertions.assertEquals((Object)"Hello", (Object)foo);
        });
    }

    @Test
    public void testConsumeReceiveBodyString() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        String body = (String)this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER, String.class);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeTwiceReceiveBodyString() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        String body = (String)this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER, String.class);
        Assertions.assertEquals((Object)"Hello", (Object)body);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Bye");
        body = (String)this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER, String.class);
        Assertions.assertEquals((Object)"Bye", (Object)body);
    }

    @Test
    public void testConsumeReceiveBodyStringNoWait() {
        String body = (String)this.consumer.receiveBodyNoWait("seda:" + TEST_SEDA_CONSUMER, String.class);
        Assertions.assertNull((Object)body);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            String foo = (String)this.consumer.receiveBodyNoWait("seda:" + TEST_SEDA_CONSUMER, String.class);
            Assertions.assertEquals((Object)"Hello", (Object)foo);
        });
    }

    @Test
    public void testConsumeReceiveEndpoint() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        Exchange out = this.consumer.receive(endpoint);
        Assertions.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    @Test
    public void testConsumeReceiveEndpointTimeout() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        Exchange out = this.consumer.receive(endpoint, 1000L);
        Assertions.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    @Test
    public void testConsumeReceiveEndpointNoWait() {
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        Exchange out = this.consumer.receiveNoWait(endpoint);
        Assertions.assertNull((Object)out);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            Exchange foo = this.consumer.receiveNoWait(endpoint);
            if (foo != null) {
                Assertions.assertEquals((Object)"Hello", (Object)foo.getIn().getBody());
            }
            return foo != null;
        });
    }

    @Test
    public void testConsumeReceiveEndpointBody() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        Object body = this.consumer.receiveBody(endpoint);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeReceiveEndpointBodyTimeout() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        Object body = this.consumer.receiveBody(endpoint, 1000L);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeReceiveEndpointBodyType() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        String body = (String)this.consumer.receiveBody(endpoint, String.class);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeReceiveEndpointBodyTimeoutType() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        String body = (String)this.consumer.receiveBody(endpoint, 1000L, String.class);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeReceiveBodyTimeoutType() {
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        String body = (String)this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER, 1000L, String.class);
        Assertions.assertEquals((Object)"Hello", (Object)body);
    }

    @Test
    public void testConsumeReceiveEndpointBodyTypeNoWait() {
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        String out = (String)this.consumer.receiveBodyNoWait(endpoint, String.class);
        Assertions.assertNull((Object)out);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            String foo = (String)this.consumer.receiveBodyNoWait(endpoint, String.class);
            Assertions.assertEquals((Object)"Hello", (Object)foo);
        });
    }

    @Test
    public void testConsumeReceiveEndpointBodyNoWait() {
        Assertions.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:" + TEST_SEDA_CONSUMER);
        Object out = this.consumer.receiveBodyNoWait(endpoint);
        Assertions.assertNull((Object)out);
        this.template.sendBody("seda:" + TEST_SEDA_CONSUMER, (Object)"Hello");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Object foo = this.consumer.receiveBodyNoWait(endpoint);
            Assertions.assertEquals((Object)"Hello", (Object)foo);
        });
    }

    @Test
    public void testReceiveException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        Exchange out = this.template.send("seda:" + TEST_SEDA_CONSUMER, (Exchange)exchange);
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertNotNull((Object)out.getException());
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER, String.class), (String)"Should have thrown an exception");
        DefaultConsumerTemplateTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getMessage());
    }

    @Test
    public void testReceiveOut() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getMessage().setBody((Object)"Bye World");
        this.template.send("seda:" + TEST_SEDA_CONSUMER, (Exchange)exchange);
        String out = (String)this.consumer.receiveBody("seda:" + TEST_SEDA_CONSUMER, String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    @Test
    public void testCacheConsumers() {
        DefaultConsumerTemplate template = new DefaultConsumerTemplate((CamelContext)this.context);
        template.setMaximumCacheSize(500);
        template.start();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            template.receiveNoWait(e);
        }
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).until(() -> DefaultConsumerTemplateTest.lambda$testCacheConsumers$7((ConsumerTemplate)template));
        Assertions.assertEquals((int)500, (int)template.getCurrentCacheSize(), (String)"Size should be 500");
        template.stop();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
    }

    @Test
    public void testCacheConsumersFromContext() {
        ConsumerTemplate template = this.context.createConsumerTemplate(500);
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            template.receiveNoWait(e);
        }
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).until(() -> {
            template.cleanUp();
            return template.getCurrentCacheSize() == 500;
        });
        Assertions.assertEquals((int)500, (int)template.getCurrentCacheSize(), (String)"Size should be 500");
        template.stop();
        Assertions.assertEquals((int)0, (int)template.getCurrentCacheSize(), (String)"Size should be 0");
    }

    @Test
    public void testDoneUoW() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        Exchange exchange = this.consumer.receive(this.fileUri("?initialDelay=0&delay=10&delete=true"));
        Assertions.assertNotNull((Object)exchange);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody(String.class));
        DefaultConsumerTemplateTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        this.consumer.doneUoW(exchange);
        DefaultConsumerTemplateTest.assertFileNotExists(this.testFile(TEST_FILE_NAME));
    }

    private static /* synthetic */ Boolean lambda$testCacheConsumers$7(ConsumerTemplate template) throws Exception {
        template.cleanUp();
        return template.getCurrentCacheSize() == 500;
    }
}

