/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.PollingConsumer;
import org.apache.camel.support.cache.DefaultConsumerCache;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultConsumerCacheTest
extends ContextTestSupport {
    @Test
    public void testCacheConsumers() {
        DefaultConsumerCache cache = new DefaultConsumerCache((Object)this, (CamelContext)this.context, 0);
        cache.start();
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 0");
        for (int i = 0; i < 1003; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            PollingConsumer p = cache.acquirePollingConsumer(e);
            Assertions.assertNotNull((Object)p, (String)"the polling consumer should not be null");
        }
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> {
            cache.cleanUp();
            Assertions.assertEquals((int)1000, (int)cache.size(), (String)"Size should be 1000");
        });
        cache.stop();
    }
}

