/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultComponentValidateURITest
extends ContextTestSupport {
    @Test
    public void testNoParameters() {
        Endpoint endpoint = this.context.getEndpoint("timer://foo");
        Assertions.assertNotNull((Object)endpoint, (String)"Should have created an endpoint");
    }

    @Test
    public void testUnknownParameter() {
        Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.context.getEndpoint("timer://foo?delay=250&unknown=1&period=500"), (String)"Should have thrown ResolveEndpointFailedException");
    }

    @Test
    public void testDoubleAmpersand() {
        Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.context.getEndpoint("timer://foo?delay=250&&period=500"), (String)"Should have thrown ResolveEndpointFailedException");
    }

    @Test
    public void testTrailingAmpersand() {
        Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.context.getEndpoint("timer://foo?delay=250&period=500&"), (String)"Should have thrown ResolveEndpointFailedException");
    }

    @Test
    public void testScheduledPollConsumerOptions() {
        Endpoint endpint = this.context.getEndpoint("file://foo2?delay=1000");
        Assertions.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://foo2?delay=1000&initialDelay=5000");
        Assertions.assertNotNull((Object)endpint);
        endpint = this.context.getEndpoint("file://foo2?delay=1000&initialDelay=5000&useFixedDelay=false");
        Assertions.assertNotNull((Object)endpint);
    }
}

