/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultComponentTest
extends ContextTestSupport {
    @Test
    public void testGetAndRemoveParameterEmptyMap() {
        HashMap parameters = new HashMap();
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testGetAndRemoveParameterEmptyMapDefault() {
        HashMap parameters = new HashMap();
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class, 5);
        Assertions.assertEquals((int)5, (int)value);
    }

    @Test
    public void testGetAndRemoveParameterEmptyMapDefaultIsNull() {
        HashMap parameters = new HashMap();
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class, null);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testGetAndRemoveParameterToInteger() {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("size", 200);
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class);
        Assertions.assertEquals((int)200, (int)value);
    }

    @Test
    public void testGetAndRemoveParameterToIntegerDefault() {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("size", 200);
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "level", Integer.class, 4);
        Assertions.assertEquals((int)4, (int)value);
    }

    @Test
    public void testResolveAndRemoveReferenceParameter() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#beginning");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Date value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "date", Date.class);
        Assertions.assertEquals((Object)new Date(0L), (Object)value);
        parameters.put("date", "beginning");
        value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "date", Date.class);
        Assertions.assertEquals((Object)new Date(0L), (Object)value);
    }

    @Test
    public void testResolveAndRemoveReferenceParameterWithConversion() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("number", "#numeric");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.resolveAndRemoveReferenceParameter(parameters, "number", Integer.class);
        Assertions.assertEquals((int)12345, (int)value);
    }

    @Test
    public void testResolveAndRemoveReferenceParameterWithFailedConversion() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("number", "#non-numeric");
        MyComponent my = new MyComponent((CamelContext)this.context);
        TypeConversionException ex = (TypeConversionException)Assertions.assertThrows(TypeConversionException.class, () -> my.resolveAndRemoveReferenceParameter(parameters, "number", Integer.class), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Error during type conversion from type: java.lang.String to the required type: java.lang.Integer with value abc due to java.lang.NumberFormatException: For input string: \"abc\"", (Object)ex.getMessage());
    }

    @Test
    public void testResolveAndRemoveReferenceParameterNotInRegistry() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#somewhen");
        MyComponent my = new MyComponent((CamelContext)this.context);
        NoSuchBeanException e = (NoSuchBeanException)Assertions.assertThrows(NoSuchBeanException.class, () -> my.resolveAndRemoveReferenceParameter(parameters, "date", Date.class), (String)"returned without finding object in registry");
        Assertions.assertEquals((Object)"No bean could be found in the registry for: somewhen of type: java.util.Date", (Object)e.getMessage());
    }

    @Test
    public void testResolveAndRemoveReferenceParameterNotInMapDefault() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#beginning");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Date value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "wrong", Date.class, new Date(1L));
        Assertions.assertEquals((Object)new Date(1L), (Object)value);
    }

    @Test
    public void testResolveAndRemoveReferenceParameterNotInMapNull() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#beginning");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Date value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "wrong", Date.class);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testResolveAndRemoveReferenceListParameterElement() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#bean1");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)1, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
    }

    @Test
    public void testResolveAndRemoveReferenceListParameterListComma() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#bean1,#bean2");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
        Assertions.assertEquals((Object)new Date(11L), values.get(1));
        parameters.put("dates", "bean1,bean2");
        values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
        Assertions.assertEquals((Object)new Date(11L), values.get(1));
    }

    @Test
    public void testResolveAndRemoveReferenceListParameterListCommaTrim() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", " #bean1 , #bean2 ");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
        Assertions.assertEquals((Object)new Date(11L), values.get(1));
        parameters.put("dates", " bean1 , bean2 ");
        values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
        Assertions.assertEquals((Object)new Date(11L), values.get(1));
    }

    @Test
    public void testResolveAndRemoveReferenceListParameterListBean() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#listBean");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
        Assertions.assertEquals((Object)new Date(11L), values.get(1));
        parameters.put("dates", "#listBean");
        values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)new Date(10L), values.get(0));
        Assertions.assertEquals((Object)new Date(11L), values.get(1));
    }

    @Test
    public void testResolveAndRemoveReferenceListParameterInvalidBean() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#bean1,#bean3");
        MyComponent my = new MyComponent((CamelContext)this.context);
        NoSuchBeanException e = (NoSuchBeanException)Assertions.assertThrows(NoSuchBeanException.class, () -> my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class), (String)"returned without finding object in registry");
        Assertions.assertEquals((Object)"No bean could be found in the registry for: bean3 of type: java.util.Date", (Object)e.getMessage());
    }

    @Test
    public void testGetAndRemoveOrResolveReferenceParameter() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("size", 123);
        parameters.put("date", "#bean1");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveOrResolveReferenceParameter(parameters, "size", Integer.class);
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((int)123, (int)value);
        Assertions.assertEquals((int)1, (int)parameters.size());
        Date bean1 = (Date)my.getAndRemoveOrResolveReferenceParameter(parameters, "date", Date.class);
        Assertions.assertNotNull((Object)bean1);
        Assertions.assertEquals((Object)new Date(10L), (Object)bean1);
        Assertions.assertEquals((int)0, (int)parameters.size());
        Integer age = (Integer)my.getAndRemoveOrResolveReferenceParameter(parameters, "age", Integer.class, 7);
        Assertions.assertNotNull((Object)age);
        Assertions.assertEquals((int)7, (int)age);
    }

    @Test
    public void testContextShouldBeSet() {
        MyComponent my = new MyComponent(null);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((MyComponent)my).start(), (String)"Should have thrown a IllegalArgumentException");
        Assertions.assertEquals((Object)"camelContext must be specified", (Object)e.getMessage());
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Date bean1 = new Date(10L);
        Date bean2 = new Date(11L);
        Registry registry = super.createCamelRegistry();
        registry.bind("beginning", (Object)new Date(0L));
        registry.bind("bean1", (Object)bean1);
        registry.bind("bean2", (Object)bean2);
        registry.bind("listBean", Arrays.asList(bean1, bean2));
        registry.bind("numeric", (Object)"12345");
        registry.bind("non-numeric", (Object)"abc");
        return registry;
    }

    private static final class MyComponent
    extends DefaultComponent {
        private MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return null;
        }
    }
}

