/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultComponentReferencePropertiesTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("myExpression", (Object)ExpressionBuilder.bodyExpression());
        return registry;
    }

    @Test
    public void testEmptyPath() throws Exception {
        DefaultComponent component = new DefaultComponent((CamelContext)this.context){

            protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
                Assertions.assertEquals((Object)"foo://?name=Christian", (Object)uri);
                Assertions.assertEquals((Object)"", (Object)remaining);
                Assertions.assertEquals((int)1, (int)parameters.size());
                Assertions.assertEquals((Object)"Christian", (Object)parameters.get("name"));
                return null;
            }
        };
        component.createEndpoint("foo://?name=Christian");
    }

    @Test
    public void testOnlyStringSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?name=Claus");
        Assertions.assertNotNull((Object)((Object)endpoint));
        Assertions.assertEquals((Object)"Claus", (Object)endpoint.name);
        Assertions.assertNull((Object)endpoint.expression);
        Assertions.assertNull((Object)endpoint.stringExpression);
    }

    @Test
    public void testCallStringSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?expression=hello");
        Assertions.assertNotNull((Object)((Object)endpoint));
        Assertions.assertEquals((Object)"hello", (Object)endpoint.stringExpression);
        Assertions.assertNull((Object)endpoint.expression);
        Assertions.assertNull((Object)endpoint.name);
    }

    @Test
    public void testNoBeanInRegistryThenCallStringSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?expression=#hello");
        Assertions.assertNotNull((Object)((Object)endpoint));
        Assertions.assertEquals((Object)"#hello", (Object)endpoint.stringExpression);
        Assertions.assertNull((Object)endpoint.expression);
        Assertions.assertNull((Object)endpoint.name);
    }

    @Test
    public void testCallExpressionSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?expression=#myExpression");
        Assertions.assertNotNull((Object)((Object)endpoint));
        Assertions.assertNull((Object)endpoint.stringExpression);
        Assertions.assertNotNull((Object)endpoint.expression);
        Assertions.assertNull((Object)endpoint.name);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)endpoint.expression.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testCallSingleExpressionSetter() throws Exception {
        MyComponent component = new MyComponent((CamelContext)this.context);
        MyEndpoint endpoint = (MyEndpoint)component.createEndpoint("foo://?special=#myExpression");
        Assertions.assertNotNull((Object)((Object)endpoint));
        Assertions.assertNull((Object)endpoint.stringExpression);
        Assertions.assertNull((Object)endpoint.expression);
        Assertions.assertNull((Object)endpoint.name);
        Assertions.assertNotNull((Object)endpoint.special);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)endpoint.special.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testTypoInParameter() {
        MyComponent component = new MyComponent((CamelContext)this.context);
        Assertions.assertThrows(ResolveEndpointFailedException.class, () -> component.createEndpoint("foo://?xxxexpression=#hello"), (String)"Should have throw a ResolveEndpointFailedException");
    }

    @Test
    public void testTypoInParameterValue() {
        MyComponent component = new MyComponent((CamelContext)this.context);
        Assertions.assertThrows(Exception.class, () -> component.createEndpoint("foo://?special=#dummy"), (String)"Should have throw a Exception");
    }

    public static final class MyComponent
    extends DefaultComponent {
        private MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            MyEndpoint result = new MyEndpoint(uri, (Component)this);
            this.setProperties((Endpoint)result, parameters);
            return result;
        }
    }

    public static final class MyEndpoint
    extends DefaultEndpoint {
        private Expression expression;
        private String stringExpression;
        private String name;
        private Expression special;

        private MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public boolean isSingleton() {
            return true;
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        public void setExpression(String expression) {
            this.stringExpression = expression;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSpecial(Expression special) {
            this.special = special;
        }
    }
}

