/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.CookiePolicy;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultComponentAutowiredTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry reg = super.createCamelRegistry();
        reg.bind("mycomponent-component", (Object)new MyComponentConfigurer());
        reg.bind("chf", (Object)new MyContentHandlerFactory());
        return reg;
    }

    @Test
    public void testAutowired() {
        this.context.addComponent("mycomponent", (Component)new MyComponent((CamelContext)this.context));
        MyComponent my = (MyComponent)this.context.getComponent("mycomponent", MyComponent.class);
        Assertions.assertNotNull((Object)((Object)my));
        ContentHandlerFactory chf = (ContentHandlerFactory)this.context.getRegistry().lookupByName("chf");
        Assertions.assertNotNull((Object)chf);
        Assertions.assertSame((Object)chf, (Object)my.getContentHandlerFactory());
        Assertions.assertNull((Object)my.getCookiePolicy());
    }

    private static class MyComponentConfigurer
    extends PropertyConfigurerSupport
    implements GeneratedPropertyConfigurer,
    PropertyConfigurerGetter {
        private MyComponentConfigurer() {
        }

        public String[] getAutowiredNames() {
            return new String[]{"contentHandlerFactory"};
        }

        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            if ("contentHandlerFactory".equals(name)) {
                MyComponent comp = (MyComponent)((Object)target);
                comp.setContentHandlerFactory((ContentHandlerFactory)value);
                return true;
            }
            return false;
        }

        public Class<?> getOptionType(String name, boolean ignoreCase) {
            if ("contentHandlerFactory".equals(name)) {
                return ContentHandlerFactory.class;
            }
            return null;
        }

        public Object getOptionValue(Object target, String name, boolean ignoreCase) {
            return null;
        }
    }

    private static class MyContentHandlerFactory
    implements ContentHandlerFactory {
        private MyContentHandlerFactory() {
        }

        @Override
        public ContentHandler createContentHandler(String mimetype) {
            return null;
        }
    }

    private static final class MyComponent
    extends DefaultComponent {
        private ContentHandlerFactory contentHandlerFactory;
        private CookiePolicy cookiePolicy;

        private MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return null;
        }

        public ContentHandlerFactory getContentHandlerFactory() {
            return this.contentHandlerFactory;
        }

        public void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
            this.contentHandlerFactory = contentHandlerFactory;
        }

        public CookiePolicy getCookiePolicy() {
            return this.cookiePolicy;
        }

        public void setCookiePolicy(CookiePolicy cookiePolicy) {
            this.cookiePolicy = cookiePolicy;
        }
    }
}

