/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.CookiePolicy;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultComponentAutowiredFalseTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry reg = super.createCamelRegistry();
        reg.bind("mycomponent-component", (Object)new MyComponentConfigurer());
        reg.bind("mycomponent-endpoint-configurer", (Object)new MyComponentConfigurer());
        reg.bind("chf", (Object)new MyContentHandlerFactory());
        return reg;
    }

    @Test
    public void testAutowiredFalse() {
        MyComponent my = new MyComponent((CamelContext)this.context);
        my.setAutowiredEnabled(false);
        this.context.addComponent("mycomponent", (Component)my);
        my = (MyComponent)this.context.getComponent("mycomponent", MyComponent.class);
        Assertions.assertNotNull((Object)((Object)my));
        ContentHandlerFactory chf = (ContentHandlerFactory)this.context.getRegistry().lookupByName("chf");
        Assertions.assertNotNull((Object)chf);
        Assertions.assertNull((Object)my.getContentHandlerFactory());
        Assertions.assertNull((Object)my.getCookiePolicy());
    }

    @Test
    public void testAutowiredFalseWithEndpointTrue() {
        MyComponent my = new MyComponent((CamelContext)this.context);
        my.setAutowiredEnabled(false);
        this.context.addComponent("mycomponent", (Component)my);
        my = (MyComponent)this.context.getComponent("mycomponent", MyComponent.class);
        Assertions.assertNotNull((Object)((Object)my));
        ContentHandlerFactory chf = (ContentHandlerFactory)this.context.getRegistry().lookupByName("chf");
        Assertions.assertNotNull((Object)chf);
        Assertions.assertNull((Object)my.getContentHandlerFactory());
        Assertions.assertNull((Object)my.getCookiePolicy());
        MyEndpoint me = (MyEndpoint)this.context.getEndpoint("mycomponent://test", MyEndpoint.class);
        Assertions.assertNull((Object)me.getContentHandlerFactory());
    }

    @Test
    public void testAutowiredTrue() {
        MyComponent my = new MyComponent((CamelContext)this.context);
        my.setAutowiredEnabled(true);
        this.context.addComponent("mycomponent", (Component)my);
        my = (MyComponent)this.context.getComponent("mycomponent", MyComponent.class);
        Assertions.assertNotNull((Object)((Object)my));
        ContentHandlerFactory chf = (ContentHandlerFactory)this.context.getRegistry().lookupByName("chf");
        Assertions.assertNotNull((Object)chf);
        Assertions.assertSame((Object)chf, (Object)my.getContentHandlerFactory());
        Assertions.assertNull((Object)my.getCookiePolicy());
    }

    private static class MyComponentConfigurer
    extends PropertyConfigurerSupport
    implements GeneratedPropertyConfigurer,
    PropertyConfigurerGetter {
        private MyComponentConfigurer() {
        }

        public String[] getAutowiredNames() {
            return new String[]{"contentHandlerFactory"};
        }

        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            if ("contentHandlerFactory".equals(name)) {
                if (target instanceof MyComponent) {
                    MyComponent comp = (MyComponent)((Object)target);
                    comp.setContentHandlerFactory((ContentHandlerFactory)value);
                } else {
                    MyEndpoint endp = (MyEndpoint)((Object)target);
                    endp.setContentHandlerFactory((ContentHandlerFactory)value);
                }
                return true;
            }
            return false;
        }

        public Class<?> getOptionType(String name, boolean ignoreCase) {
            if ("contentHandlerFactory".equals(name)) {
                return ContentHandlerFactory.class;
            }
            return null;
        }

        public Object getOptionValue(Object target, String name, boolean ignoreCase) {
            return null;
        }
    }

    private static class MyContentHandlerFactory
    implements ContentHandlerFactory {
        private MyContentHandlerFactory() {
        }

        @Override
        public ContentHandler createContentHandler(String mimetype) {
            return null;
        }
    }

    @org.apache.camel.spi.annotations.Component(value="mycomponent")
    private static final class MyComponent
    extends DefaultComponent {
        private ContentHandlerFactory contentHandlerFactory;
        private CookiePolicy cookiePolicy;

        private MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            MyEndpoint me = new MyEndpoint();
            me.setComponent((Component)this);
            return me;
        }

        public ContentHandlerFactory getContentHandlerFactory() {
            return this.contentHandlerFactory;
        }

        public void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
            this.contentHandlerFactory = contentHandlerFactory;
        }

        public CookiePolicy getCookiePolicy() {
            return this.cookiePolicy;
        }

        public void setCookiePolicy(CookiePolicy cookiePolicy) {
            this.cookiePolicy = cookiePolicy;
        }
    }

    private static final class MyEndpoint
    extends DefaultEndpoint {
        private ContentHandlerFactory contentHandlerFactory;

        private MyEndpoint() {
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }

        public ContentHandlerFactory getContentHandlerFactory() {
            return this.contentHandlerFactory;
        }

        public void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
            this.contentHandlerFactory = contentHandlerFactory;
        }
    }
}

