/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.net.URL;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultClassResolverTest {
    @Test
    public void testResolveClass() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer");
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveClassType() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer", Integer.class);
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveClassClassLoader() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer", DefaultClassResolverTest.class.getClassLoader());
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveClassClassLoaderType() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer", Integer.class, DefaultClassResolverTest.class.getClassLoader());
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveMandatoryClass() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer");
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveMandatoryClassType() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer", Integer.class);
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveMandatorySimpleClassType() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("Byte", Byte.class);
        Assertions.assertNotNull((Object)clazz);
        clazz = resolver.resolveMandatoryClass("java.lang.Byte", Byte.class);
        Assertions.assertNotNull((Object)clazz);
        Class clazz2 = resolver.resolveMandatoryClass("Long", Long.class);
        Assertions.assertNotNull((Object)clazz2);
        clazz2 = resolver.resolveMandatoryClass("java.lang.Long", Long.class);
        Assertions.assertNotNull((Object)clazz2);
        Class clazz3 = resolver.resolveMandatoryClass("String", String.class);
        Assertions.assertNotNull((Object)clazz3);
        clazz3 = resolver.resolveMandatoryClass("java.lang.String", String.class);
        Assertions.assertNotNull((Object)clazz3);
        Class clazz4 = resolver.resolveMandatoryClass("Byte[]", Byte[].class);
        Assertions.assertNotNull((Object)clazz4);
        clazz4 = resolver.resolveMandatoryClass("java.lang.Byte[]", Byte[].class);
        Assertions.assertNotNull((Object)clazz4);
        Class clazz5 = resolver.resolveMandatoryClass("Object[]", Object[].class);
        Assertions.assertNotNull((Object)clazz5);
        clazz5 = resolver.resolveMandatoryClass("java.lang.Object[]", Object[].class);
        Assertions.assertNotNull((Object)clazz5);
        Class clazz6 = resolver.resolveMandatoryClass("String[]", String[].class);
        Assertions.assertNotNull((Object)clazz6);
        clazz6 = resolver.resolveMandatoryClass("java.lang.String[]", String[].class);
        Assertions.assertNotNull((Object)clazz6);
    }

    @Test
    public void testResolveMandatoryClassClassLoader() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer", DefaultClassResolverTest.class.getClassLoader());
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveMandatoryClassClassLoaderType() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer", Integer.class, DefaultClassResolverTest.class.getClassLoader());
        Assertions.assertNotNull((Object)clazz);
    }

    @Test
    public void testResolveMandatoryClassNotFound() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Assertions.assertThrows(ClassNotFoundException.class, () -> resolver.resolveMandatoryClass("com.FooBar"), (String)"Should thrown an exception");
    }

    @Test
    public void testLoadResourceAsUri() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        URL url = resolver.loadResourceAsURL("log4j2.properties");
        Assertions.assertNotNull((Object)url);
    }

    @Test
    public void testLoadResourceAsStream() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        InputStream is = resolver.loadResourceAsStream("log4j2.properties");
        Assertions.assertNotNull((Object)is);
    }

    @Test
    public void testResolveJavaMathClass() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Math");
        Assertions.assertNotNull((Object)clazz);
    }
}

