/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextWithLifecycleStrategyRestartTest
extends ContextTestSupport {
    private final MyStrategy strategy = new MyStrategy();

    @Test
    public void testRestart() throws Exception {
        Assertions.assertTrue((boolean)this.context.getStatus().isStarted());
        Assertions.assertFalse((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)1, (int)this.strategy.getContextStartCounter());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertFalse((boolean)this.context.getStatus().isStarted());
        Assertions.assertTrue((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.start();
        Assertions.assertTrue((boolean)this.context.getStatus().isStarted());
        Assertions.assertFalse((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)2, (int)this.strategy.getContextStartCounter());
        this.template = this.context.createProducerTemplate();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteStopped() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertEquals((int)0, (int)this.strategy.getRemoveCounter());
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((int)0, (int)this.strategy.getRemoveCounter());
        this.context.removeRoute("foo");
        Assertions.assertEquals((int)1, (int)this.strategy.getRemoveCounter());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)this.strategy);
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    private static class MyStrategy
    extends LifecycleStrategySupport {
        private final AtomicInteger contextStartCounter = new AtomicInteger();
        private final AtomicInteger removeCounter = new AtomicInteger();

        private MyStrategy() {
        }

        public void onContextStarting(CamelContext context) {
            this.contextStartCounter.incrementAndGet();
        }

        public void onRoutesRemove(Collection<Route> routes) {
            this.removeCounter.incrementAndGet();
        }

        public int getContextStartCounter() {
            return this.contextStartCounter.get();
        }

        public int getRemoveCounter() {
            return this.removeCounter.get();
        }
    }
}

