/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextSuspendResumeRouteTest
extends ContextTestSupport {
    @Test
    public void testSuspendResume() throws Exception {
        Assertions.assertFalse((boolean)this.context.isSuspended());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.suspend();
        Thread.sleep(1000L);
        Awaitility.await().atMost(200L, TimeUnit.MILLISECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertDoesNotThrow(() -> this.template.sendBody("seda:foo", (Object)"B")));
        mock.assertIsSatisfied(1000L);
        Assertions.assertTrue((boolean)this.context.isSuspended());
        Assertions.assertFalse((boolean)this.context.getStatus().isStarted());
        Assertions.assertTrue((boolean)this.context.getStatus().isSuspended());
        Assertions.assertFalse((boolean)this.context.getStatus().isStopped());
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.resume();
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)this.context.isSuspended());
        Assertions.assertTrue((boolean)this.context.getStatus().isStarted());
        Assertions.assertFalse((boolean)this.context.getStatus().isSuspended());
        Assertions.assertFalse((boolean)this.context.getStatus().isStopped());
        this.context.stop();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

