/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class DefaultCamelContextSuspendResumeRouteStartupOrderTest
extends ContextTestSupport {
    @Test
    public void testSuspendResume() throws Exception {
        Assertions.assertFalse((boolean)this.context.isSuspended());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.suspend();
        Awaitility.await().atMost(100L, TimeUnit.MILLISECONDS).pollDelay(10L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.template.sendBody("seda:foo", (Object)"B"));
        mock.assertIsSatisfied(1000L);
        Assertions.assertTrue((boolean)this.context.isSuspended());
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.resume();
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)this.context.isSuspended());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("C").startupOrder(3).to("log:foo")).to("direct:bar");
                ((RouteDefinition)this.from("direct:baz").routeId("A").startupOrder(1).to("log:baz")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("B").startupOrder(2).to("log:bar")).to("direct:baz");
            }
        };
    }
}

