/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextRestartTest
extends ContextTestSupport {
    @Test
    public void testRestart() throws Exception {
        Assertions.assertTrue((boolean)this.context.getStatus().isStarted());
        Assertions.assertFalse((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertFalse((boolean)this.context.getStatus().isStarted());
        Assertions.assertTrue((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.start();
        Assertions.assertTrue((boolean)this.context.getStatus().isStarted());
        Assertions.assertFalse((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.template = this.context.createProducerTemplate();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }
}

