/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Predicate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultDataFormat;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextResolverTest {
    private static CamelContext context;

    @BeforeAll
    public static void createContext() {
        context = new DefaultCamelContext();
        context.getRegistry().bind("green-component", (Object)new SampleComponent(true));
        context.getRegistry().bind("green-dataformat", (Object)new SampleDataFormat(true));
        context.getRegistry().bind("green-language", (Object)new SampleLanguage(true));
        context.getRegistry().bind("yellow", (Object)new SampleComponent(false));
        context.getRegistry().bind("yellow-component", (Object)new SampleComponent(true));
        context.getRegistry().bind("red", (Object)new SampleDataFormat(false));
        context.getRegistry().bind("red-dataformat", (Object)new SampleDataFormat(true));
        context.getRegistry().bind("blue", (Object)new SampleLanguage(false));
        context.getRegistry().bind("blue-language", (Object)new SampleLanguage(true));
        context.start();
    }

    @AfterAll
    public static void destroyContext() {
        context.stop();
        context = null;
    }

    @Test
    public void testComponentWithFallbackNames() {
        Component component = context.getComponent("green");
        Assertions.assertNotNull((Object)component, (String)"Component not found in registry");
        boolean b = component instanceof SampleComponent;
        Assertions.assertTrue((boolean)b, (String)"Wrong instance type of the Component");
        Assertions.assertTrue((boolean)((SampleComponent)component).isFallback(), (String)"Here we should have the fallback Component");
    }

    @Test
    public void testComponentWithBothNames() {
        Component component = context.getComponent("yellow");
        Assertions.assertNotNull((Object)component, (String)"Component not found in registry");
        boolean b = component instanceof SampleComponent;
        Assertions.assertTrue((boolean)b, (String)"Wrong instance type of the Component");
        Assertions.assertFalse((boolean)((SampleComponent)component).isFallback(), (String)"Here we should NOT have the fallback Component");
    }

    @Test
    public void testDataFormatWithFallbackNames() {
        DataFormat dataFormat = context.resolveDataFormat("green");
        Assertions.assertNotNull((Object)dataFormat, (String)"DataFormat not found in registry");
        boolean b = dataFormat instanceof SampleDataFormat;
        Assertions.assertTrue((boolean)b, (String)"Wrong instance type of the DataFormat");
        Assertions.assertTrue((boolean)((SampleDataFormat)dataFormat).isFallback(), (String)"Here we should have the fallback DataFormat");
    }

    @Test
    public void testDataformatWithBothNames() {
        DataFormat dataFormat = context.resolveDataFormat("red");
        Assertions.assertNotNull((Object)dataFormat, (String)"DataFormat not found in registry");
        boolean b = dataFormat instanceof SampleDataFormat;
        Assertions.assertTrue((boolean)b, (String)"Wrong instance type of the DataFormat");
        Assertions.assertFalse((boolean)((SampleDataFormat)dataFormat).isFallback(), (String)"Here we should NOT have the fallback DataFormat");
    }

    @Test
    public void testLanguageWithFallbackNames() {
        Language language = context.resolveLanguage("green");
        Assertions.assertNotNull((Object)language, (String)"Language not found in registry");
        boolean b = language instanceof SampleLanguage;
        Assertions.assertTrue((boolean)b, (String)"Wrong instance type of the Language");
        Assertions.assertTrue((boolean)((SampleLanguage)language).isFallback(), (String)"Here we should have the fallback Language");
    }

    @Test
    public void testLanguageWithBothNames() {
        Language language = context.resolveLanguage("blue");
        Assertions.assertNotNull((Object)language, (String)"Language not found in registry");
        boolean b = language instanceof SampleLanguage;
        Assertions.assertTrue((boolean)b, (String)"Wrong instance type of the Language");
        Assertions.assertFalse((boolean)((SampleLanguage)language).isFallback(), (String)"Here we should NOT have the fallback Language");
    }

    @Test
    public void testNullLookupComponent() {
        Component component = context.getComponent("xxxxxxxxx");
        Assertions.assertNull((Object)component, (String)"Non-existent Component should be null");
    }

    @Test
    public void testNullLookupDataFormat() {
        DataFormat dataFormat = context.resolveDataFormat("xxxxxxxxx");
        Assertions.assertNull((Object)dataFormat, (String)"Non-existent DataFormat should be null");
    }

    @Test
    public void testNullLookupLanguage() {
        Assertions.assertThrows(NoSuchLanguageException.class, () -> context.resolveLanguage("xxxxxxxxx"));
    }

    public static class SampleComponent
    extends DefaultComponent {
        private boolean fallback;

        SampleComponent(boolean fallback) {
            this.fallback = fallback;
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public boolean isFallback() {
            return this.fallback;
        }

        public void setFallback(boolean fallback) {
            this.fallback = fallback;
        }
    }

    public static class SampleDataFormat
    extends DefaultDataFormat {
        private boolean fallback;

        SampleDataFormat(boolean fallback) {
            this.fallback = fallback;
        }

        public void marshal(Exchange exchange, Object graph, OutputStream stream) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public Object unmarshal(Exchange exchange, InputStream stream) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public boolean isFallback() {
            return this.fallback;
        }

        public void setFallback(boolean fallback) {
            this.fallback = fallback;
        }
    }

    public static class SampleLanguage
    implements Language {
        private boolean fallback;

        SampleLanguage(boolean fallback) {
            this.fallback = fallback;
        }

        public Predicate createPredicate(String expression) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public Expression createExpression(String expression) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public boolean isFallback() {
            return this.fallback;
        }

        public void setFallback(boolean fallback) {
            this.fallback = fallback;
        }
    }
}

