/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextAutoStartupTest
extends TestSupport {
    @Test
    public void testAutoStartupFalseContextStart() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext(false);
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(false));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        });
        camel.start();
        Assertions.assertTrue((boolean)camel.isStarted());
        Assertions.assertEquals((int)1, (int)camel.getRoutes().size());
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStopped());
        camel.getRouteController().startAllRoutes();
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }

    @Test
    public void testAutoStartupFalseRouteStart() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext(false);
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(false));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        });
        camel.start();
        Assertions.assertTrue((boolean)camel.isStarted());
        Assertions.assertEquals((int)1, (int)camel.getRoutes().size());
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStopped());
        camel.startRoute("foo");
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }

    @Test
    public void testAutoStartupTrue() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext(false);
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(true));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        });
        camel.start();
        Assertions.assertTrue((boolean)camel.isStarted());
        Assertions.assertEquals((int)1, (int)camel.getRoutes().size());
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }

    @Test
    public void testAutoStartupFalseRouteOverride() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext(false);
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(false));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").autoStartup(true).to("mock:result");
            }
        });
        camel.start();
        Assertions.assertTrue((boolean)camel.isStarted());
        Assertions.assertEquals((int)1, (int)camel.getRoutes().size());
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStopped());
        Assertions.assertFalse((boolean)camel.getRouteController().getRouteStatus("foo").isStarted());
        camel.getRouteController().startAllRoutes();
        Assertions.assertTrue((boolean)camel.getRouteController().getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }
}

