/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.impl.OriginalMessageProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextAllowUseOriginalMessageTrueTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setAllowUseOriginalMessage(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testUseOriginalMessageTrue() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("HasOriginal", (Object)"true");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("OriginalBody", (Object)"World");
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).header("OriginalExchangeId")).isNotNull();
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:start").transform().simple("Bye ${body}")).process((Processor)new OriginalMessageProcessor())).to("mock:result");
            }
        };
    }
}

