/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.FooBar;
import org.apache.camel.impl.MySerialBean;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultCamelBeanPostProcessorTest
extends ContextTestSupport {
    private CamelBeanPostProcessor postProcessor;

    @Test
    public void testPostProcessor() throws Exception {
        FooService foo = new FooService();
        foo.setFooEndpoint("seda:input");
        foo.setBarEndpoint("mock:result");
        this.postProcessor.postProcessBeforeInitialization((Object)foo, "foo");
        this.postProcessor.postProcessAfterInitialization((Object)foo, "foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:input", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Object bean = this.context.getRegistry().lookupByName("myCoolBean");
        Assertions.assertNotNull((Object)bean);
        DefaultCamelBeanPostProcessorTest.assertIsInstanceOf(MySerialBean.class, bean);
        bean = this.context.getRegistry().lookupByName("FooService");
        Assertions.assertNotNull((Object)bean);
        DefaultCamelBeanPostProcessorTest.assertIsInstanceOf(FooService.class, bean);
        bean = this.context.getRegistry().lookupByName("doSomething");
        Assertions.assertNotNull((Object)bean);
        DefaultCamelBeanPostProcessorTest.assertIsInstanceOf(FooBar.class, bean);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
    }

    @BindToRegistry
    public static class FooService {
        private String fooEndpoint;
        private String barEndpoint;
        @Produce
        private ProducerTemplate bar;
        @BindToRegistry(value="myCoolBean")
        private final MySerialBean myBean = new MySerialBean();

        @BindToRegistry
        public FooBar doSomething() {
            return new FooBar();
        }

        public String getFooEndpoint() {
            return this.fooEndpoint;
        }

        public void setFooEndpoint(String fooEndpoint) {
            this.fooEndpoint = fooEndpoint;
        }

        public String getBarEndpoint() {
            return this.barEndpoint;
        }

        public void setBarEndpoint(String barEndpoint) {
            this.barEndpoint = barEndpoint;
        }

        @Consume
        public void onFoo(String input) {
            this.bar.sendBody((Object)input);
        }
    }
}

