/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Properties;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.PropertyInject;
import org.apache.camel.impl.MySerialBean;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultCamelBeanPostProcessorFieldFirstTest
extends ContextTestSupport {
    private CamelBeanPostProcessor postProcessor;

    @Test
    public void testPostProcessor() throws Exception {
        FooService foo = new FooService();
        Properties prop = new Properties();
        prop.setProperty("foo", "Donald Duck");
        this.context.getPropertiesComponent().setInitialProperties(prop);
        this.postProcessor.postProcessBeforeInitialization((Object)foo, "foo");
        this.postProcessor.postProcessAfterInitialization((Object)foo, "foo");
        Object bean = this.context.getRegistry().lookupByName("myCoolBean");
        Assertions.assertNotNull((Object)bean);
        MySerialBean msb = DefaultCamelBeanPostProcessorFieldFirstTest.assertIsInstanceOf(MySerialBean.class, bean);
        Assertions.assertEquals((int)123, (int)msb.getId());
        Assertions.assertEquals((Object)"Donald Duck", (Object)msb.getName());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
    }

    @BindToRegistry
    public static class FooService {
        @PropertyInject(value="foo")
        private String foo;
        @PropertyInject(value="number", defaultValue="123")
        private Integer number;

        @BindToRegistry(value="myCoolBean")
        public MySerialBean myBean() {
            MySerialBean myBean = new MySerialBean();
            myBean.setId(this.number);
            myBean.setName(this.foo);
            return myBean;
        }
    }
}

