/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.camel.BeanInject;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.MySerialBean;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultCamelBeanPostProcessorComplexFieldFirstTest
extends ContextTestSupport {
    private CamelBeanPostProcessor postProcessor;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myDS", (Object)new DummyDataSource());
        return answer;
    }

    @Test
    public void testPostProcessor() throws Exception {
        FooService foo = new FooService();
        this.postProcessor.postProcessBeforeInitialization((Object)foo, "foo");
        this.postProcessor.postProcessAfterInitialization((Object)foo, "foo");
        Object bean = this.context.getRegistry().lookupByName("myCoolBean");
        Assertions.assertNotNull((Object)bean);
        MySerialBean msb = DefaultCamelBeanPostProcessorComplexFieldFirstTest.assertIsInstanceOf(MySerialBean.class, bean);
        Assertions.assertEquals((int)123, (int)msb.getId());
        Assertions.assertEquals((Object)DummyDataSource.class.getName(), (Object)msb.getName());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
    }

    private static class DummyDataSource
    implements DataSource {
        private DummyDataSource() {
        }

        @Override
        public Connection getConnection() {
            return null;
        }

        @Override
        public Connection getConnection(String username, String password) {
            return null;
        }

        @Override
        public PrintWriter getLogWriter() {
            return null;
        }

        @Override
        public void setLogWriter(PrintWriter out) {
        }

        @Override
        public void setLoginTimeout(int seconds) {
        }

        @Override
        public int getLoginTimeout() {
            return 0;
        }

        @Override
        public Logger getParentLogger() {
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }
    }

    @BindToRegistry
    public static class FooService {
        @BeanInject
        private DataSource ctx;

        @BindToRegistry(value="myCoolBean")
        public MySerialBean myBean() {
            MySerialBean myBean = new MySerialBean();
            myBean.setId(123);
            myBean.setName(this.ctx.getClass().getName());
            return myBean;
        }
    }
}

