/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultAsyncProcessorAwaitManager;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.support.DefaultExchange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class DefaultAsyncProcessorAwaitManagerTest {
    private DefaultAsyncProcessorAwaitManager defaultAsyncProcessorAwaitManager;
    private DefaultExchange exchange;
    private CountDownLatch latch;
    private Thread thread;

    @Test
    public void testNoMessageHistory() throws Exception {
        this.startAsyncProcess();
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        MatcherAssert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithEmptyList() throws Exception {
        this.startAsyncProcess();
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        MatcherAssert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithNullMessageHistory() throws Exception {
        this.startAsyncProcess();
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        MatcherAssert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithNullElements() throws Exception {
        this.startAsyncProcess();
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        MatcherAssert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithNotNullElements() throws Exception {
        this.startAsyncProcess();
        this.exchange.getExchangeExtension().setHistoryNodeId("nodeId");
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        MatcherAssert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Object)"nodeId"));
        this.waitForEndOfAsyncProcess();
    }

    private void waitForEndOfAsyncProcess() {
        this.latch.countDown();
        while (this.thread.isAlive()) {
        }
    }

    private void startAsyncProcess() throws InterruptedException {
        this.defaultAsyncProcessorAwaitManager = new DefaultAsyncProcessorAwaitManager();
        this.latch = new CountDownLatch(1);
        BackgroundAwait backgroundAwait = new BackgroundAwait();
        this.exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        this.thread = new Thread(backgroundAwait);
        this.thread.start();
        Thread.sleep(100L);
    }

    private class BackgroundAwait
    implements Runnable {
        private BackgroundAwait() {
        }

        @Override
        public void run() {
            DefaultAsyncProcessorAwaitManagerTest.this.defaultAsyncProcessorAwaitManager.await((Exchange)DefaultAsyncProcessorAwaitManagerTest.this.exchange, DefaultAsyncProcessorAwaitManagerTest.this.latch);
        }
    }
}

