/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.RefDataFormatTest;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class DataFormatPropertyPlaceholderTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Properties prop = new Properties();
        prop.put("myDataformat", "reverse");
        context.getPropertiesComponent().setInitialProperties(prop);
        return context;
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("reverse", (Object)new RefDataFormatTest.MyReverseDataFormat());
        return registry;
    }

    @Test
    public void testMarshalRef() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"CBA"});
        this.template.sendBody("direct:a", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUnmarshalRef() throws Exception {
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBody("direct:b", (Object)"CBA");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").marshal("{{myDataformat}}")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").unmarshal("{{myDataformat}}")).to("mock:b");
            }
        };
    }
}

