/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataFormatContextAwareTest
extends ContextTestSupport {
    private final MyDataFormat my = new MyDataFormat();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("my", (Object)this.my);
        return registry;
    }

    @Test
    public void testLanguageCamelContextAware() {
        DataFormat df = this.context.resolveDataFormat("my");
        Assertions.assertNotNull((Object)df);
        MyDataFormat me = DataFormatContextAwareTest.assertIsInstanceOf(MyDataFormat.class, df);
        Assertions.assertNotNull((Object)me.getCamelContext());
    }

    private static class MyDataFormat
    extends ServiceSupport
    implements DataFormat,
    CamelContextAware {
        private CamelContext camelContext;

        private MyDataFormat() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        }

        public Object unmarshal(Exchange exchange, InputStream stream) {
            return null;
        }
    }
}

