/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultUnitOfWork;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.junit.jupiter.api.Test;

public class CustomUnitOfWorkFactoryTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getCamelContextExtension().addContextPlugin(UnitOfWorkFactory.class, (Object)new MyUnitOfWorkFactory());
        return context;
    }

    @Test
    public void testCustomUnitOfWorkFactory() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("before", (Object)"I was here");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }

    private static class MyUnitOfWorkFactory
    implements UnitOfWorkFactory {
        private MyUnitOfWorkFactory() {
        }

        public UnitOfWork createUnitOfWork(Exchange exchange) {
            return new MyUnitOfWork(exchange);
        }
    }

    private static class MyUnitOfWork
    extends DefaultUnitOfWork {
        MyUnitOfWork(Exchange exchange) {
            super(exchange);
        }

        public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
            exchange.getIn().setHeader("before", (Object)"I was here");
            return callback;
        }

        public boolean isBeforeAfterProcess() {
            return true;
        }
    }
}

