/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.support.processor.DelegateProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomIdFactoryTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CustomIdFactoryTest.class);
    private static int counter;
    private static String ids;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        ids = "";
        counter = 0;
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                CustomIdFactoryTest.this.context.getCamelContextExtension().addContextPlugin(NodeIdFactory.class, (Object)CustomIdFactoryTest.buildNodeIdFactory());
                CustomIdFactoryTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new MyDebuggerCheckingId());
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Hello")).to("mock:hello")).otherwise().log("Hey")).to("mock:other")).end();
            }
        };
    }

    private static NodeIdFactory buildNodeIdFactory() {
        return definition -> "#" + definition.getShortName() + ++counter + "#";
    }

    @Test
    public void testHello() throws Exception {
        Assertions.assertEquals((Object)"#route1#", (Object)((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"#choice3##to4#", (Object)ids);
    }

    @Test
    public void testOther() throws Exception {
        Assertions.assertEquals((Object)"#route1#", (Object)((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"#choice3##log5##to6#", (Object)ids);
    }

    private static class MyDebuggerCheckingId
    implements InterceptStrategy {
        private MyDebuggerCheckingId() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, final NamedNode definition, Processor target, Processor nextTarget) {
            return new DelegateProcessor(target){

                protected void processNext(Exchange exchange) throws Exception {
                    LOG.debug("Debugging at: {} with id: {} with exchange: {}", new Object[]{definition, definition.getId(), exchange});
                    ids = ids + definition.getId();
                    super.processNext(exchange);
                }
            };
        }
    }
}

