/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.HeadersMapFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomHeadersMapFactoryRouteTest
extends ContextTestSupport {
    private final HeadersMapFactory custom = new CustomHeadersMapFactory();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getCamelContextExtension().setHeadersMapFactory(this.custom);
        return context;
    }

    @Test
    public void testCustomHeaders() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)123);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("FOO", (Object)456);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("Bar", (Object)"yes");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("FOO", 456);
        headers.put("Bar", "yes");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        Assertions.assertSame((Object)this.custom, (Object)this.context.getCamelContextExtension().getHeadersMapFactory());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }

    private static class CustomHeadersMapFactory
    implements HeadersMapFactory {
        private CustomHeadersMapFactory() {
        }

        public Map<String, Object> newMap() {
            return new HashMap<String, Object>();
        }

        public Map<String, Object> newMap(Map<String, Object> map) {
            return new HashMap<String, Object>(map);
        }

        public boolean isInstanceOf(Map<String, Object> map) {
            return map instanceof HashMap;
        }

        public boolean isCaseInsensitive() {
            return false;
        }
    }
}

