/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConvertible;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomBulkTypeConvertersTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        CustomBulkTypeConverters customBulkTypeConverters = new CustomBulkTypeConverters();
        context.getTypeConverterRegistry().addBulkTypeConverters((BulkTypeConverters)customBulkTypeConverters);
        context.getTypeConverterRegistry().addConverter(new TypeConvertible(String.class, MyOrder.class), (TypeConverter)customBulkTypeConverters);
        context.getTypeConverterRegistry().addConverter(new TypeConvertible(Integer.class, MyOrder.class), (TypeConverter)customBulkTypeConverters);
        return context;
    }

    @Test
    public void testCoreTypeConverter() {
        MyOrder order = (MyOrder)this.context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        Assertions.assertEquals((int)123, (int)order.getId());
        order = (MyOrder)this.context.getTypeConverter().convertTo(MyOrder.class, (Object)44);
        Assertions.assertEquals((int)44, (int)order.getId());
        order = (MyOrder)this.context.getTypeConverter().convertTo(MyOrder.class, (Object)"Hello".getBytes());
        Assertions.assertNull((Object)order);
    }

    private static class CustomBulkTypeConverters
    implements BulkTypeConverters {
        private CustomBulkTypeConverters() {
        }

        public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
            return null;
        }

        public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {
            if (from == String.class && to == MyOrder.class) {
                MyOrder order = new MyOrder();
                order.setId(Integer.parseInt(value.toString()));
                return (T)order;
            }
            if (from == Integer.class && to == MyOrder.class) {
                MyOrder order = new MyOrder();
                order.setId((Integer)value);
                return (T)order;
            }
            return null;
        }

        public int size() {
            return 2;
        }
    }

    private static class MyOrder {
        private int id;

        private MyOrder() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

