/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.PollingConsumer;
import org.apache.camel.support.cache.DefaultConsumerCache;
import org.apache.camel.support.service.ServiceSupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerCacheOneCapacityTest
extends ContextTestSupport {
    @Test
    public void testConsumerCacheOneCapacity() {
        DefaultConsumerCache cache = new DefaultConsumerCache((Object)this, (CamelContext)this.context, 1);
        cache.start();
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 0");
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("?fileName=foo.txt&initialDelay=0&delay=10"));
        PollingConsumer consumer = cache.acquirePollingConsumer(endpoint);
        Assertions.assertNotNull((Object)consumer);
        Assertions.assertEquals((Object)"Started", (Object)((ServiceSupport)consumer).getStatus().name());
        consumer.receive(50L);
        boolean found = Thread.getAllStackTraces().keySet().stream().anyMatch(t -> t.getName().contains(this.testDirectory().toString()));
        Assertions.assertFalse((boolean)found, (String)"Should not find file consumer thread");
        cache.releasePollingConsumer(endpoint, consumer);
        Assertions.assertTrue((boolean)((ServiceSupport)consumer).isStarted(), (String)"Should still be started");
        cache.stop();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((Object)"Stopped", (Object)((ServiceSupport)consumer).getStatus().name()));
        found = Thread.getAllStackTraces().keySet().stream().anyMatch(t -> t.getName().contains(this.testDirectory().toString()));
        Assertions.assertFalse((boolean)found, (String)"Should not find file consumer thread");
    }
}

