/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.support.ClassicUuidGenerator;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicUuidGeneratorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ClassicUuidGeneratorTest.class);

    @Test
    public void testGenerateUUID() {
        ClassicUuidGenerator uuidGenerator = new ClassicUuidGenerator();
        String firstUUID = uuidGenerator.generateUuid();
        String secondUUID = uuidGenerator.generateUuid();
        Assertions.assertNotSame((Object)firstUUID, (Object)secondUUID, (String)("The first UUID " + firstUUID + " is equal to the second " + secondUUID));
    }

    @Test
    public void testPerformance() {
        ClassicUuidGenerator uuidGenerator = new ClassicUuidGenerator();
        StopWatch watch = new StopWatch();
        LOG.info("First id: {}", (Object)uuidGenerator.generateUuid());
        for (int i = 0; i < 500000; ++i) {
            uuidGenerator.generateUuid();
        }
        LOG.info("Last id: {}", (Object)uuidGenerator.generateUuid());
        LOG.info("Took {}", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true));
    }

    @Test
    public void testSanitizeHostName() {
        Assertions.assertEquals((Object)"somehost.lan", (Object)ClassicUuidGenerator.sanitizeHostName((String)"somehost.lan"));
        Assertions.assertEquals((Object)"otherhost.lan", (Object)ClassicUuidGenerator.sanitizeHostName((String)"other\u0e08host.lan"));
    }
}

