/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Produce;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CamelProduceInterfaceEventNotifierTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();
    private CamelBeanPostProcessor postProcessor;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                if (event instanceof CamelEvent.ExchangeSendingEvent || event instanceof CamelEvent.ExchangeSentEvent) {
                    CamelProduceInterfaceEventNotifierTest.this.events.add(event);
                }
            }
        });
        return context;
    }

    @Test
    public void testPostProcessor() throws Exception {
        this.events.clear();
        int before = this.events.size();
        Assertions.assertEquals((int)0, (int)before);
        MySender sender = new MySender();
        this.postProcessor.postProcessBeforeInitialization((Object)sender, "foo");
        this.postProcessor.postProcessAfterInitialization((Object)sender, "foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        sender.hello.sayHello("Hello World");
        this.assertMockEndpointsSatisfied();
        int after = this.events.size();
        Assertions.assertEquals((int)2, (int)after);
        boolean b1 = this.events.get(0) instanceof CamelEvent.ExchangeSendingEvent;
        Assertions.assertTrue((boolean)b1);
        boolean b = this.events.get(1) instanceof CamelEvent.ExchangeSentEvent;
        Assertions.assertTrue((boolean)b);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
    }

    static class MySender {
        @Produce(value="mock:result")
        FooService hello;

        MySender() {
        }
    }

    static interface FooService {
        public void sayHello(String var1);
    }
}

