/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultExecutorServiceManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelCustomDefaultThreadPoolProfileTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camel = super.createCamelContext();
        ThreadPoolProfile profile = new ThreadPoolProfile("custom");
        profile.setPoolSize(Integer.valueOf(5));
        profile.setMaxPoolSize(Integer.valueOf(15));
        profile.setKeepAliveTime(Long.valueOf(25L));
        profile.setMaxQueueSize(Integer.valueOf(250));
        profile.setAllowCoreThreadTimeOut(Boolean.valueOf(true));
        profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
        DefaultExecutorServiceManager executorServiceManager = new DefaultExecutorServiceManager(camel);
        executorServiceManager.setDefaultThreadPoolProfile(profile);
        camel.setExecutorServiceManager((ExecutorServiceManager)executorServiceManager);
        return camel;
    }

    @Test
    public void testCamelCustomDefaultThreadPoolProfile() {
        DefaultExecutorServiceManager manager = (DefaultExecutorServiceManager)this.context.getExecutorServiceManager();
        ThreadPoolProfile profile = manager.getDefaultThreadPoolProfile();
        Assertions.assertEquals((int)5, (int)profile.getPoolSize());
        Assertions.assertEquals((int)15, (int)profile.getMaxPoolSize());
        Assertions.assertEquals((long)25L, (long)profile.getKeepAliveTime());
        Assertions.assertEquals((int)250, (int)profile.getMaxQueueSize());
        Assertions.assertTrue((boolean)profile.getAllowCoreThreadTimeOut());
        Assertions.assertEquals((Object)ThreadPoolRejectedPolicy.Abort, (Object)profile.getRejectedPolicy());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").threads(25, 45).to("mock:result");
            }
        };
    }
}

