/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelContextTracker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class CamelContextTrackerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerSet() {
        MyContextTracker tracker = new MyContextTracker();
        DefaultCamelContext camel1 = new DefaultCamelContext();
        DefaultCamelContext camel2 = new DefaultCamelContext();
        Assertions.assertEquals((int)0, (int)tracker.names.size());
        try {
            tracker.open();
            Assertions.assertEquals((int)0, (int)tracker.names.size());
            DefaultCamelContext camel3 = new DefaultCamelContext();
            Assertions.assertEquals((int)1, (int)tracker.names.size());
            Assertions.assertEquals((Object)camel3.getName(), (Object)tracker.names.get(0));
            camel1.stop();
            camel2.stop();
            camel3.stop();
            Assertions.assertEquals((int)0, (int)tracker.names.size());
        }
        finally {
            tracker.close();
        }
    }

    private static final class MyContextTracker
    extends CamelContextTracker {
        private final List<String> names = new ArrayList<String>();

        private MyContextTracker() {
        }

        public void contextCreated(CamelContext camelContext) {
            this.names.add(camelContext.getName());
        }

        public void contextDestroyed(CamelContext camelContext) {
            this.names.remove(camelContext.getName());
        }
    }
}

