/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelContextReloadStrategyTest
extends ContextTestSupport {
    @Test
    public void testContextReload() throws Exception {
        Assertions.assertEquals((Object)"Hello 1", (Object)this.context.resolvePropertyPlaceholders("{{hello}}"));
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello 1", "Hello 1"});
        this.template.sendBody("direct:start", (Object)"Camel");
        this.template.sendBody("direct:start", (Object)"Dog");
        mock.assertIsSatisfied();
        ContextReloadStrategy crs = (ContextReloadStrategy)this.context.hasService(ContextReloadStrategy.class);
        Assertions.assertNotNull((Object)crs);
        crs.onReload((Object)"CamelContextReloadStrategyTest");
        Assertions.assertEquals((Object)"Hello 2", (Object)this.context.resolvePropertyPlaceholders("{{hello}}"));
        mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Hello 2", "Hello 2"});
        this.template.sendBody("direct:start", (Object)"World");
        this.template.sendBody("direct:start", (Object)"Moon");
        mock.assertIsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = context.getPropertiesComponent();
        MySource my = new MySource();
        ServiceHelper.startService((Service)my);
        pc.addPropertiesSource((PropertiesSource)my);
        DefaultContextReloadStrategy crs = new DefaultContextReloadStrategy();
        context.addService((Object)crs);
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.constant("{{hello}}"))).to("mock:result");
            }
        };
    }

    private static class MySource
    extends ServiceSupport
    implements PropertiesSource {
        private int counter;

        private MySource() {
        }

        public String getName() {
            return "my";
        }

        public String getProperty(String name) {
            if ("hello".equals(name)) {
                return "Hello " + this.counter;
            }
            return null;
        }

        protected void doStart() {
            ++this.counter;
        }
    }
}

