/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelContextReloadStrategyPropertiesFunctionTest
extends ContextTestSupport {
    private final MyFunction my = new MyFunction();

    @Test
    public void testContextReload() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye 1", "Bye 1"});
        this.template.sendBody("direct:start", (Object)"Camel");
        this.template.sendBody("direct:start", (Object)"Dog");
        mock.assertIsSatisfied();
        this.my.incCounter();
        ContextReloadStrategy crs = (ContextReloadStrategy)this.context.hasService(ContextReloadStrategy.class);
        Assertions.assertNotNull((Object)crs);
        crs.onReload((Object)"CamelContextReloadStrategyTest");
        mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye 2", "Bye 2"});
        this.template.sendBody("direct:start", (Object)"World");
        this.template.sendBody("direct:start", (Object)"Moon");
        mock.assertIsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = context.getPropertiesComponent();
        pc.addPropertiesFunction((PropertiesFunction)this.my);
        DefaultContextReloadStrategy crs = new DefaultContextReloadStrategy();
        context.addService((Object)crs);
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.constant("{{my:Bye}}"))).to("mock:result");
            }
        };
    }

    private static class MyFunction
    implements PropertiesFunction {
        private int counter = 1;

        private MyFunction() {
        }

        public void incCounter() {
            ++this.counter;
        }

        public String getName() {
            return "my";
        }

        public String apply(String remainder) {
            return remainder + " " + this.counter;
        }
    }
}

