/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.net.URL;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CamelContextAddRouteDefinitionsFromXmlTest
extends ContextTestSupport {
    protected JAXBContext jaxbContext;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.jaxbContext = (JAXBContext)PluginHelper.getModelJAXBContextFactory((CamelContext)this.context).newJAXBContext();
    }

    protected Object parseUri(String uri) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL resource = this.getClass().getResource(uri);
        Assertions.assertNotNull((Object)resource, (String)("Cannot find resource on the classpath: " + uri));
        Object value = unmarshaller.unmarshal(resource);
        return value;
    }

    protected RouteDefinition loadRoute(String uri) throws Exception {
        Object route = this.parseUri(uri);
        return CamelContextAddRouteDefinitionsFromXmlTest.assertIsInstanceOf(RouteDefinition.class, route);
    }

    @Test
    public void testAddRouteDefinitionsFromXml() throws Exception {
        RouteDefinition route = this.loadRoute("route1.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted(), (String)"Route should be started");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRemoveRouteDefinitionsFromXml() throws Exception {
        RouteDefinition route = this.loadRoute("route1.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted(), (String)"Route should be started");
        this.context.removeRouteDefinition(route);
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        Assertions.assertNull((Object)this.context.getRouteController().getRouteStatus("foo"));
        Assertions.assertEquals((int)0, (int)this.context.getRouteDefinitions().size());
    }

    @Test
    public void testAddRouteDefinitionsFromXml2() throws Exception {
        RouteDefinition route = this.loadRoute("route2.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped(), (String)"Route should be stopped");
        this.context.getRouteController().startRoute("foo");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted(), (String)"Route should be started");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAddRouteDefinitionsFromXmlIsPrepared() throws Exception {
        RouteDefinition route = this.loadRoute("route1.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted(), (String)"Route should be started");
        route = this.context.getRouteDefinition("foo");
        for (ProcessorDefinition output : route.getOutputs()) {
            Assertions.assertNotNull((Object)output.getParent(), (String)"Parent should be set on output");
            Assertions.assertEquals((Object)route, (Object)output.getParent());
        }
    }

    @Test
    public void testAddRouteDefinitionsFromXml3() throws Exception {
        RouteDefinition route = this.loadRoute("route3.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted(), (String)"Route should be started");
        this.getMockEndpoint("mock:foo").whenExchangeReceived(2, new Processor(){

            public void process(Exchange exchange) {
                exchange.setException((Throwable)new IllegalArgumentException("Damn"));
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAddRouteDefinitionsAfterExceptionFromXml() throws Exception {
        RouteDefinition route = this.loadRoute("route4_error.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        try {
            this.context.addRouteDefinition(route);
        }
        catch (Exception exception) {
            // empty catch block
        }
        route = this.loadRoute("route4_ok.xml");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
    }
}

