/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.net.URL;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.DummyRestProcessorFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CamelContextAddRestDefinitionsFromXmlTest
extends ContextTestSupport {
    protected JAXBContext jaxbContext;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        registry.bind("dummy-rest-api", (Object)new DummyRestProcessorFactory());
        return registry;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.jaxbContext = (JAXBContext)PluginHelper.getModelJAXBContextFactory((CamelContext)this.context).newJAXBContext();
    }

    protected Object parseUri(String uri) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL resource = this.getClass().getResource(uri);
        Assertions.assertNotNull((Object)resource, (String)("Cannot find resource on the classpath: " + uri));
        return unmarshaller.unmarshal(resource);
    }

    protected RestDefinition loadRest(String uri) throws Exception {
        Object rest = this.parseUri(uri);
        return CamelContextAddRestDefinitionsFromXmlTest.assertIsInstanceOf(RestDefinition.class, rest);
    }

    @Test
    public void testAddRestDefinitionsFromXml() throws Exception {
        RestDefinition rest = this.loadRest("rest1.xml");
        Assertions.assertNotNull((Object)rest);
        Assertions.assertEquals((Object)"foo", (Object)rest.getId());
        Assertions.assertEquals((int)0, (int)this.context.getRestDefinitions().size());
        this.context.getRestDefinitions().add(rest);
        Assertions.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        List routeDefinitions = rest.asRouteDefinition((CamelContext)this.context);
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.context.addRouteDefinition(routeDefinition);
        }
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        for (Route route : this.context.getRoutes()) {
            Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus(route.getRouteId()).isStarted(), (String)"Route should be started");
        }
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:get-say-hello-bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.restConfiguration().host("localhost").component("dummy-rest").apiContextPath("/api-docs");
            }
        };
    }
}

