/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.PropertyInject;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelBeanPostProcessorInjector;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ReflectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CamelBeanPostProcessorInjectorTest
extends ContextTestSupport {
    private CamelBeanPostProcessor postProcessor;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
        this.postProcessor.addCamelBeanPostProjectInjector((CamelBeanPostProcessorInjector)new MyInjector());
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
    }

    @Test
    public void testBeanPostInjector() throws Exception {
        MyService service = new MyService();
        this.postProcessor.postProcessBeforeInitialization((Object)service, "service");
        this.postProcessor.postProcessAfterInitialization((Object)service, "service");
        Assertions.assertEquals((Object)"Donald Duck", (Object)service.getName());
        Assertions.assertEquals((Object)"changed-foo", (Object)service.getFoo());
        CamelLogger logger = (CamelLogger)this.context.getRegistry().lookupByName("createLogger");
        Assertions.assertNotNull((Object)logger);
    }

    private class MyInjector
    implements CamelBeanPostProcessorInjector {
        private MyInjector() {
        }

        public void onFieldInject(Field field, Object bean, String beanName) {
            if (field.getName().equals("foo")) {
                ReflectionHelper.setField((Field)field, (Object)bean, (Object)"changed-foo");
            }
        }

        public void onMethodInject(Method method, Object bean, String beanName) {
            if (method.getName().equals("createLogger")) {
                Object out = ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{"changed-bar"});
                CamelBeanPostProcessorInjectorTest.this.context.getRegistry().bind(method.getName(), out);
            }
        }
    }

    public static class MyService {
        @PropertyInject(value="myName", defaultValue="Donald Duck")
        private String name;
        @PropertyInject(value="myFoo", defaultValue="myDefault")
        private String foo;

        public String getName() {
            return this.name;
        }

        public String getFoo() {
            return this.foo;
        }

        public CamelLogger createLogger(String name) {
            return new CamelLogger(name);
        }
    }
}

